/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;
import org.jrimum.texgit.Field;
import org.jrimum.texgit.TextStream;
import org.jrimum.utilix.ObjectUtil;

public abstract class AbstractLineOfFields
implements TextStream,
List<Field<?>> {
    private static final long serialVersionUID = 9071816265288953266L;
    private static Logger log = Logger.getLogger(AbstractLineOfFields.class);
    private Integer fieldsLength;
    private Integer stringLength;
    private List<Field<?>> fields;

    protected AbstractLineOfFields() {
        this.fields = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     */
    public AbstractLineOfFields(Integer fieldsLength, Integer stringLength) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameters fieldsLength: " + fieldsLength));
            log.debug((Object)("Parameters stringLength: " + stringLength));
        }
        if (ObjectUtil.isNotNull(fieldsLength, "fieldsLength") && ObjectUtil.isNotNull(stringLength, "stringLength")) {
            if (fieldsLength <= 0) {
                IllegalArgumentException e = new IllegalArgumentException("O tamanho dos campos [ " + fieldsLength + " ] deve ser maior que 0!");
                log.error((Object)"", (Throwable)e);
                throw e;
            }
            if (stringLength <= 0) {
                IllegalArgumentException e = new IllegalArgumentException("O tamanho da String [ " + stringLength + " ] deve ser maior que 0!");
                log.error((Object)"", (Throwable)e);
                throw e;
            }
            this.fields = new ArrayList(fieldsLength);
            this.fieldsLength = fieldsLength;
            this.stringLength = stringLength;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"LineOfFields Initialized.");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Instance fieldsLength: " + fieldsLength));
            log.debug((Object)("Instance stringLength: " + stringLength));
        }
    }

    @Override
    public void read(String lineOfFields) {
        if (ObjectUtil.isNotNull(lineOfFields, "lineOfFields")) {
            this.isConsistent(lineOfFields);
            StringBuilder builder = new StringBuilder(lineOfFields);
            for (Field<?> field : this.fields) {
                field.read(builder.substring(0, field.getLength()));
                builder.delete(0, field.getLength());
            }
            Object var2_2 = null;
        }
    }

    @Override
    public String write() {
        StringBuilder lineOfFields = new StringBuilder("");
        if (ObjectUtil.isNotNull(this.fields, "fields")) {
            for (Field<?> field : this.fields) {
                lineOfFields.append(field.write());
            }
            this.isConsistent(lineOfFields);
        }
        return lineOfFields.toString();
    }

    protected final boolean isConsistent(StringBuilder lineOfFields) {
        boolean is = false;
        if (this.isConsistent(lineOfFields.toString())) {
            if (this.fieldsLength.intValue() == this.size()) {
                is = true;
            } else {
                IllegalStateException e = new IllegalStateException("O tamanho dos campos [ " + this.size() + " ] \u00e9 incompat\u00edvel com o especificado [" + this.fieldsLength + "]!");
                log.error((Object)"", (Throwable)e);
                throw e;
            }
        }
        return is;
    }

    protected final boolean isConsistent(String lineOfFields) {
        boolean is = false;
        if (lineOfFields.length() != this.stringLength.intValue()) {
            IllegalStateException e = new IllegalStateException("O tamanho da String de campos [ " + lineOfFields.length() + " ] \u00e9 incompat\u00edvel com o especificado [" + this.stringLength + "]!");
            log.error((Object)"", (Throwable)e);
            throw e;
        }
        is = true;
        return is;
    }

    public int stringSize() {
        return this.write().length();
    }

    public Integer getFieldsLength() {
        return this.fieldsLength;
    }

    public void setFieldsLength(Integer fieldsLength) {
        this.fieldsLength = fieldsLength;
    }

    public Integer getStringLength() {
        return this.stringLength;
    }

    public void setStringLength(Integer stringLength) {
        this.stringLength = stringLength;
    }

    @Override
    public boolean add(Field<?> e) {
        return this.fields.add(e);
    }

    @Override
    public void add(int index, Field<?> element) {
        this.fields.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends Field<?>> c) {
        return this.fields.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Field<?>> c) {
        return this.fields.addAll(index, c);
    }

    @Override
    public void clear() {
        this.fields.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.fields.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.fields.containsAll(c);
    }

    @Override
    public Field<?> get(int index) {
        return this.fields.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.fields.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public Iterator<Field<?>> iterator() {
        return this.fields.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.fields.indexOf(o);
    }

    @Override
    public ListIterator<Field<?>> listIterator() {
        return this.fields.listIterator();
    }

    @Override
    public ListIterator<Field<?>> listIterator(int index) {
        return this.fields.listIterator(index);
    }

    @Override
    public Field<?> remove(int index) {
        return this.fields.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.fields.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.fields.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.fields.retainAll(c);
    }

    @Override
    public Field<?> set(int index, Field<?> element) {
        return this.fields.set(index, element);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public List<Field<?>> subList(int fromIndex, int toIndex) {
        return this.fields.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.fields.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.fields.toArray(a);
    }
}

