/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.time.DateUtils;
import org.jrimum.JRimumException;
import org.jrimum.utilix.DateUtil;
import org.jrimum.utilix.ObjectUtil;

public class BancoUtil {
    private static final long serialVersionUID = 1L;
    private static final Date DATA_BASE_DO_FATOR_DE_VENCIMENTO = new GregorianCalendar(1997, 9, 7).getTime();
    private static final Date DATA_LIMITE_DO_FATOR_DE_VENCIMENTO = new GregorianCalendar(2025, 1, 21).getTime();

    public static int calculceFatorDeVencimento(Date dataVencimento) throws JRimumException {
        Date dataVencTruncada = null;
        if (ObjectUtil.isNull(dataVencimento)) {
            throw new JRimumException(new IllegalArgumentException("Imposs\u00edvel realizar o c\u00e1lculo do fator de vencimento de uma data nula."));
        }
        dataVencTruncada = DateUtils.truncate((Date)dataVencimento, (int)5);
        if (dataVencTruncada.before(DATA_BASE_DO_FATOR_DE_VENCIMENTO) || dataVencTruncada.after(DATA_LIMITE_DO_FATOR_DE_VENCIMENTO)) {
            throw new JRimumException(new IllegalArgumentException("Para o c\u00e1lculo do fator de vencimento se faz necess\u00e1rio informar uma data entre " + DateUtil.FORMAT_DD_MM_YYYY.format(DATA_BASE_DO_FATOR_DE_VENCIMENTO) + " e " + DateUtil.FORMAT_DD_MM_YYYY.format(DATA_LIMITE_DO_FATOR_DE_VENCIMENTO)));
        }
        int fator = (int)DateUtil.calculeDiferencaEmDias(DATA_BASE_DO_FATOR_DE_VENCIMENTO, dataVencTruncada);
        return fator;
    }
}

