/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jrimum.utilix.Exceptions;

public final class ClassLoaders {
    private ClassLoaders() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public static URL getResource(String resourceName) {
        return ClassLoaders.getResource(resourceName, null);
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        URL url = null;
        if (callingClass != null) {
            url = callingClass.getResource(resourceName);
            if (url != null) {
                return url;
            }
            url = callingClass.getClassLoader().getResource(resourceName);
            if (url == null) {
                String inPagckage = String.format("%s/%s", callingClass.getPackage().getName().replaceAll("\\.", "/"), resourceName);
                url = Thread.currentThread().getContextClassLoader().getResource(inPagckage);
            } else {
                return url;
            }
        }
        if (url != null) {
            return url;
        }
        url = ClassLoaders.class.getResource(resourceName);
        if (url != null) {
            return url;
        }
        url = ClassLoaders.class.getClassLoader().getResource(resourceName);
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName) {
        return ClassLoaders.getResourceAsStream(resourceName, null);
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        try {
            return ClassLoaders.getResource(resourceName, callingClass).openStream();
        }
        catch (IOException e) {
            return (InputStream)Exceptions.throwIllegalStateException(e);
        }
    }
}

