/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.util.Collection;
import java.util.Map;
import org.jrimum.utilix.Arrays;
import org.jrimum.utilix.Exceptions;

public final class Collections {
    private Collections() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public static void checkEmpty(Collection<?> collection) {
        Collections.checkEmpty(collection, "Collection n\u00e3o nulo e com elementos! Valor [" + collection + "].");
    }

    public static void checkEmpty(Collection<?> collection, String message) {
        if (Collections.hasElement(collection)) {
            Exceptions.throwIllegalArgumentException(message);
        }
    }

    public static void checkNotEmpty(Collection<?> collection) {
        Collections.checkNotEmpty(collection, "Objeto nulo!", "Collection sem elementos!");
    }

    public static void checkNotEmpty(Collection<?> collection, String message) {
        Collections.checkNotEmpty(collection, message, message);
    }

    public static void checkEmpty(Map<?, ?> map) {
        Collections.checkEmpty(map, "Map n\u00e3o nulo e com elementos. Valor [" + map + "]");
    }

    public static void checkEmpty(Map<?, ?> map, String message) {
        if (Collections.hasElement(map)) {
            Exceptions.throwIllegalArgumentException(message);
        }
    }

    public static void checkNotEmpty(Map<?, ?> map) {
        Collections.checkNotEmpty(map, "Objeto nulo", "Map sem elementos");
    }

    public static void checkNotEmpty(Map<?, ?> map, String message) {
        Collections.checkNotEmpty(map, message, message);
    }

    public static boolean isEmpty(Collection<?> collection) {
        return !Collections.hasElement(collection);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return Collections.hasElement(collection);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return !Collections.hasElement(map);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return Collections.hasElement(map);
    }

    public static boolean hasElement(Collection<?> ... cols) {
        if (Arrays.hasElement(cols)) {
            for (Collection<?> c : cols) {
                if (!Collections.hasElement(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasElement(Map<?, ?> ... maps) {
        if (Arrays.hasElement(maps)) {
            for (Map<?, ?> m : maps) {
                if (!Collections.hasElement(m)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasElement(Collection<?> c) {
        return c != null && !c.isEmpty();
    }

    public static boolean hasElement(Map<?, ?> m) {
        return m != null && !m.isEmpty();
    }

    public static int size(Collection<?> c) {
        return c != null ? c.size() : 0;
    }

    public static int size(Map<?, ?> m) {
        return m != null ? m.size() : 0;
    }

    public static void checkNotEmpty(Collection<?> collection, String messageNullPointer, String messageIllegalArgument) {
        if (collection == null) {
            Exceptions.throwIllegalArgumentException(messageNullPointer);
        }
        if (collection.isEmpty()) {
            Exceptions.throwIllegalArgumentException(messageIllegalArgument);
        }
    }

    public static void checkNotEmpty(Map<?, ?> map, String messageNullPointer, String messageIllegalArgument) {
        if (map == null) {
            Exceptions.throwIllegalArgumentException(messageNullPointer);
        }
        if (map.isEmpty()) {
            Exceptions.throwIllegalArgumentException(messageIllegalArgument);
        }
    }
}

