/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Format;
import org.jrimum.utilix.ThreadLocalFormat;

public enum DateFormat implements Format<Date, SimpleDateFormat>
{
    DDMMYY("ddMMyy"),
    DDMMYY_B("dd/MM/yy"),
    DDMMYY_H("dd-MM-yy"),
    DDMMYY_U("dd_MM_yy"),
    DDMMYYYY("ddMMyyyy"),
    DDMMYYYY_B("dd/MM/yyyy"),
    DDMMYYYY_H("dd-MM-yyyy"),
    DDMMYYYY_U("dd_MM_yyyy"),
    YYMMDD("yyMMdd"),
    YYMMDD_B("yy/MM/dd"),
    YYMMDD_H("yy-MM-dd"),
    YYMMDD_U("yy_MM_dd"),
    YYYYMMDD("yyyyMMdd"),
    YYYYMMDD_B("yyyy/MM/dd"),
    YYYYMMDD_H("yyyy-MM-dd"),
    YYYYMMDD_U("yyyy_MM_dd"),
    HHMMSS("hhmmss"),
    HHMMSS_24("HHmmss"),
    HHMMSS_C("hh:mm:ss"),
    HHMMSS_24C("HH:mm:ss");

    private final ThreadLocalFormat<SimpleDateFormat> DATE_FORMAT;

    private DateFormat(String format) {
        this.DATE_FORMAT = new ThreadLocalFormat<SimpleDateFormat>(format){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat(this.format);
            }
        };
    }

    @Override
    public String format(Date obj) {
        return ((SimpleDateFormat)this.DATE_FORMAT.get()).format(obj);
    }

    @Override
    public Date parse(String text) {
        try {
            return ((SimpleDateFormat)this.DATE_FORMAT.get()).parse(text);
        }
        catch (ParseException e) {
            return (Date)Exceptions.throwIllegalArgumentException("DateFormat Exception!", e);
        }
    }

    @Override
    public SimpleDateFormat copy() {
        return (SimpleDateFormat)((SimpleDateFormat)this.DATE_FORMAT.get()).clone();
    }
}

