/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.jrimum.utilix.ObjectUtil;

public class DateUtil {
    private static final long serialVersionUID = 4339951860440604914L;
    public static final DateFormat FORMAT_DD_MM_YYYY = new SimpleDateFormat("dd/MM/yyyy");
    public static final DateFormat FORMAT_DDMMYY = new SimpleDateFormat("ddMMyy");
    public static final DateFormat FORMAT_YYMMDD = new SimpleDateFormat("yyMMdd");
    public static final Date DATE_NULL;

    public static Date parse(String dateAsString) {
        return DateUtil.parse(dateAsString, FORMAT_DD_MM_YYYY);
    }

    public static Date parse(String dateAsString, String dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("O formato da data n\u00e3o pode ter valor [null].");
        }
        return DateUtil.parse(dateAsString, new SimpleDateFormat(dateFormat));
    }

    public static Date parse(String dateAsString, DateFormat dateFormat) {
        Date date = null;
        if (dateAsString == null) {
            throw new NullPointerException("A String a ser convertida n\u00e3o pode ter valor [null].");
        }
        if (dateFormat == null) {
            throw new NullPointerException("O formatador n\u00e3o pode ter valor [null].");
        }
        try {
            date = dateFormat.parse(dateAsString);
        }
        catch (ParseException e) {
            String msg = "A String [" + dateAsString + "] deve ser uma data v\u00e1lida no formato";
            if (dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                msg = msg + " [" + sdf.toPattern() + "].";
            } else {
                msg = msg + " especificado.";
            }
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            iae.initCause(e);
            throw iae;
        }
        return date;
    }

    public static long calculeDiferencaEmDias(Date dataInicial, Date dataFinal) {
        long fator = 0L;
        if (ObjectUtil.isNotNull(dataInicial) && ObjectUtil.isNotNull(dataFinal)) {
            Date dataInicialTruncada = DateUtils.truncate((Date)dataInicial, (int)5);
            Date dataFinalTruncada = DateUtils.truncate((Date)dataFinal, (int)5);
            fator = (dataFinalTruncada.getTime() - dataInicialTruncada.getTime()) / 86400000L;
            if (fator < 0L) {
                fator *= -1L;
            }
        } else {
            throw new IllegalArgumentException("A data inicial [" + dataInicial + "] e a data final [" + dataFinal + "] n\u00e3o podem ter valor 'null'.");
        }
        return fator;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0, 1);
        calendar.setLenient(false);
        DATE_NULL = DateUtils.truncate((Date)calendar.getTime(), (int)1);
    }
}

