/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Objects;

public final class Dates {
    private static final Date DATE_NULL;
    public static final DateFormat FORMAT_YYMMDD;
    public static final DateFormat FORMAT_YYYYMMDD;

    private Dates() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public static Date invalidDate() {
        return (Date)DATE_NULL.clone();
    }

    public static boolean equalsInvalidDate(Date date) {
        if (date == null) {
            return false;
        }
        return DATE_NULL.compareTo(date) == 0;
    }

    public static long calculeDiferencaEmDias(Date dataInicial, Date dataFinal) {
        long fator = 0L;
        if (Objects.isNotNull(dataInicial) && Objects.isNotNull(dataFinal)) {
            Date dataInicialTruncada = DateUtils.truncate((Date)dataInicial, (int)5);
            Date dataFinalTruncada = DateUtils.truncate((Date)dataFinal, (int)5);
            fator = (dataFinalTruncada.getTime() - dataInicialTruncada.getTime()) / 86400000L;
            if (fator < 0L) {
                fator *= -1L;
            }
        } else {
            Exceptions.throwIllegalArgumentException("A data inicial [" + dataInicial + "] e a data final [" + dataFinal + "] n\u00e3o podem ter valor 'null'.");
        }
        return fator;
    }

    public static Date parse(String dateAsString, String dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("O formato da data n\u00e3o pode ter valor [null].");
        }
        return Dates.parse(dateAsString, new SimpleDateFormat(dateFormat));
    }

    public static Date parse(String dateAsString, DateFormat dateFormat) {
        Date date = null;
        if (dateAsString == null) {
            throw new NullPointerException("A String a ser convertida n\u00e3o pode ter valor [null].");
        }
        if (dateFormat == null) {
            throw new NullPointerException("O formatador n\u00e3o pode ter valor [null].");
        }
        try {
            date = dateFormat.parse(dateAsString);
        }
        catch (ParseException e) {
            String msg = "A String [" + dateAsString + "] deve ser uma data v\u00e1lida no formato";
            if (dateFormat instanceof SimpleDateFormat) {
                SimpleDateFormat sdf = (SimpleDateFormat)dateFormat;
                msg = msg + " [" + sdf.toPattern() + "].";
            } else {
                msg = msg + " especificado.";
            }
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            iae.initCause(e);
            throw iae;
        }
        return date;
    }

    public static Date truncarData(Date date) {
        if (date == null) {
            throw new NullPointerException("O data n\u00e3o pode ser nula. Imposs\u00edvel realizar o truncamento da data.");
        }
        return DateUtils.truncate((Date)date, (int)5);
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 0, 1);
        calendar.setLenient(false);
        DATE_NULL = DateUtils.truncate((Date)calendar.getTime(), (int)1);
        FORMAT_YYMMDD = new SimpleDateFormat("yyMMdd");
        FORMAT_YYYYMMDD = new SimpleDateFormat("yyyyMMdd");
    }
}

