/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.text.ParseException;
import org.jrimum.utilix.DecimalFormatSymbols;
import org.jrimum.utilix.Exceptions;
import org.jrimum.utilix.Format;
import org.jrimum.utilix.ThreadLocalLocalizedFormat;

public enum DecimalFormat implements Format<Number, java.text.DecimalFormat>
{
    NUMBER_D_BR("#,##0.0", DecimalFormatSymbols.BRASIL.copy()),
    NUMBER_DD_BR("#,##0.00", DecimalFormatSymbols.BRASIL.copy()),
    MONEY_D_BR("\u00a4 #,##0.0", DecimalFormatSymbols.BRASIL.copy()),
    MONEY_DD_BR("\u00a4 #,##0.00", DecimalFormatSymbols.BRASIL.copy());

    private final ThreadLocalLocalizedFormat<java.text.DecimalFormat, java.text.DecimalFormatSymbols> DECIMAL_FORMAT;

    private DecimalFormat(String format, java.text.DecimalFormatSymbols formatSymbols) {
        this.DECIMAL_FORMAT = new ThreadLocalLocalizedFormat<java.text.DecimalFormat, java.text.DecimalFormatSymbols>(format, formatSymbols){

            @Override
            protected java.text.DecimalFormat initialValue() {
                return new java.text.DecimalFormat(this.format, (java.text.DecimalFormatSymbols)this.formatSymbols);
            }
        };
    }

    @Override
    public String format(Number obj) {
        return ((java.text.DecimalFormat)this.DECIMAL_FORMAT.get()).format(obj);
    }

    @Override
    public Number parse(String text) {
        try {
            return ((java.text.DecimalFormat)this.DECIMAL_FORMAT.get()).parse(text);
        }
        catch (ParseException e) {
            return (Number)Exceptions.throwIllegalArgumentException("DecimalFormat Exception!", e);
        }
    }

    @Override
    public java.text.DecimalFormat copy() {
        return (java.text.DecimalFormat)((java.text.DecimalFormat)this.DECIMAL_FORMAT.get()).clone();
    }
}

