/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jrimum.utilix.ObjectUtil;

public class FileUtil {
    protected static final Logger LOG = Logger.getLogger(FileUtil.class);
    private static final long serialVersionUID = 1227314921804015225L;
    public static final int EOF = -1;
    public static final int CARRIAGE_RETURN = 1;
    public static final int NEXT_LINE = 2;
    public static final String NEW_LINE = "\r\n";

    public static byte[] bytesFromFile(File file) throws IOException {
        byte[] bytes = null;
        if (ObjectUtil.isNotNull(file)) {
            long length = file.length();
            if (length <= Integer.MAX_VALUE) {
                int offset;
                FileInputStream is = new FileInputStream(file);
                bytes = new byte[(int)length];
                int numRead = 0;
                for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
                if (offset < bytes.length) {
                    throw new IOException("N\u00e3o foi poss\u00edvel ler completamente o arquivo. [" + file.getName() + "]");
                }
                ((InputStream)is).close();
            } else {
                throw new IOException("O arquivo \u00e9 muito grande para esta transforma\u00e7\u00e3o.");
            }
        }
        return bytes;
    }

    public static File bytes2File(String pathName, byte[] bytes) throws FileNotFoundException, IOException {
        File f = null;
        if (ObjectUtil.isNotNull(pathName, "pathName") && ObjectUtil.isNotNull(bytes, "bytes")) {
            f = new File(pathName);
            FileOutputStream out = new FileOutputStream(f);
            ((OutputStream)out).write(bytes);
            out.flush();
            ((OutputStream)out).close();
        }
        return f;
    }

    public static ByteArrayOutputStream bytes2Stream(byte[] bytes) throws IOException {
        ByteArrayOutputStream byteOut = null;
        if (ObjectUtil.isNotNull(bytes, "bytes")) {
            byteOut = new ByteArrayOutputStream();
            byteOut.write(bytes);
        }
        return byteOut;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readLine(File file, int lengthOfBlock, int lineOrdinalNumber) {
        long position = 0L;
        FileChannel fc = null;
        ByteBuffer bybff = null;
        String line = null;
        if (lengthOfBlock <= 0) throw new IllegalArgumentException("lengthOfBlock : [" + lengthOfBlock + "] deve ser > 0!");
        if (lineOrdinalNumber <= 0) throw new IllegalArgumentException("lineOrdinalNumber : [" + lineOrdinalNumber + "] deve ser > 0!");
        fc = FileUtil.getReadFileChannel(file);
        try {
            if (fc.size() <= 0L) {
                throw new IllegalArgumentException("file : [" + file + "] is empty!");
            }
            bybff = ByteBuffer.allocate((lengthOfBlock += 2) - 1);
            position = (lineOrdinalNumber - 1) * lengthOfBlock;
            fc.position(position);
            fc.read(bybff);
            line = new String(bybff.array());
            fc.close();
            return line;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return line;
    }

    public static List<String> readLines(File file, int lengthOfBlock) {
        FileChannel fc = null;
        ByteBuffer bybff = null;
        ArrayList<String> blocks = null;
        if (lengthOfBlock > 0) {
            fc = FileUtil.getReadFileChannel(file);
            try {
                if (fc.size() > 0L) {
                    bybff = ByteBuffer.allocate(++lengthOfBlock - 1);
                    blocks = new ArrayList<String>(FileUtil.getNumberOfLines(fc, lengthOfBlock));
                    while (fc.read(bybff) != -1) {
                        blocks.add(new String(bybff.array()));
                        fc.position(fc.position() + 2L);
                        bybff.clear();
                    }
                } else {
                    throw new IllegalArgumentException("file : [" + file + "] est\u00e1 vazio!");
                }
                fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("lengthOfBlock : [" + lengthOfBlock + "] deve ser > 0!");
        }
        return blocks;
    }

    public static void writeLines(File file, List<String> lines) {
        FileChannel fc = null;
        ByteBuffer bybff = null;
        ByteBuffer[] bybffArray = null;
        Object line = null;
        if (ObjectUtil.isNotNull(lines) && !lines.isEmpty()) {
            bybffArray = new ByteBuffer[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                line = lines.get(i);
                bybff = ByteBuffer.allocate(((String)line).length() + 2);
                line = (String)line + NEW_LINE;
                bybff.put(((String)line).getBytes());
                bybff.rewind();
                bybffArray[i] = bybff;
            }
            fc = FileUtil.getWriteFileChannel(file);
            try {
                fc.write(bybffArray);
                fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isEmpty(File file) {
        boolean is = true;
        if (!ObjectUtil.isNotNull(file)) {
            throw new IllegalArgumentException("file : [" + file + "]!");
        }
        is = file.length() > 0L;
        return is;
    }

    public static int getNumberOfLines(File file, int lengthOfBlock) {
        int size = 0;
        if (lengthOfBlock <= 0) {
            throw new IllegalArgumentException("lengthOfBlock : [" + lengthOfBlock + "] deve ser > 0!");
        }
        size = FileUtil.getNumberOfLines(FileUtil.getReadFileChannel(file), lengthOfBlock);
        return size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getNumberOfLines(FileChannel fileChannel, int lengthOfBlock) {
        int size = 0;
        if (!ObjectUtil.isNotNull(fileChannel)) throw new IllegalArgumentException("fileChannel : [" + fileChannel + "]!");
        if (lengthOfBlock <= 0) throw new IllegalArgumentException("lengthOfBlock : [" + lengthOfBlock + "] deve ser > 0!");
        try {
            if (fileChannel.size() <= 0L) return size;
            return (int)(fileChannel.size() / (long)(++lengthOfBlock));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return size;
    }

    public static void copyTo(File fileIn, File fileOut) {
        FileChannel fcin = FileUtil.getReadFileChannel(fileIn);
        FileChannel fcout = FileUtil.getWriteFileChannel(fileOut);
        try {
            fcin.transferTo(0L, fcin.size(), fcout);
            fcin.close();
            fcout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static FileChannel getReadFileChannel(File file) {
        FileInputStream fis = null;
        FileChannel fc = null;
        if (!FileUtil.isEmpty(file)) {
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            fc = fis.getChannel();
        }
        return fc;
    }

    public static FileChannel getWriteFileChannel(File file) {
        FileOutputStream fos = null;
        FileChannel fc = null;
        if (!FileUtil.isEmpty(file)) {
            try {
                fos = new FileOutputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            fc = fos.getChannel();
        }
        return fc;
    }

    public static List<String> readFile(String pathName) {
        if (ObjectUtil.isNotNull(pathName)) {
            ArrayList<String> lines = new ArrayList<String>();
            try {
                String s;
                File arq = new File(pathName);
                BufferedReader reader = new BufferedReader(new FileReader(arq));
                do {
                    if (!ObjectUtil.isNotNull(s = reader.readLine())) continue;
                    lines.add(s);
                } while (ObjectUtil.isNotNull(s));
                reader.close();
                return lines;
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)(" RECEBER PROCESSAMENTO String pathNomeArquivo: " + pathName), (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)(" RECEBER PROCESSAMENTO String pathNomeArquivo: " + pathName), (Throwable)e);
            }
        }
        return null;
    }

    public static List<String> readFile(File file) {
        ArrayList<String> lines = null;
        if (!FileUtil.isEmpty(file)) {
            try {
                String s;
                lines = new ArrayList<String>();
                BufferedReader reader = new BufferedReader(new FileReader(file));
                do {
                    if (!ObjectUtil.isNotNull(s = reader.readLine())) continue;
                    lines.add(s);
                } while (ObjectUtil.isNotNull(s));
                reader.close();
                return lines;
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)" RECEBER PROCESSAMENTO ", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)" RECEBER PROCESSAMENTO ", (Throwable)e);
            }
        }
        return lines;
    }

    public static void markAs(String pathName, String tag) {
        if (ObjectUtil.isNotNull(pathName) & ObjectUtil.isNotNull(tag)) {
            File file = new File(pathName);
            File newFile = new File(pathName + tag);
            file.renameTo(newFile);
        }
    }

    public static boolean renameTo(String path, String name, String newName) {
        if (ObjectUtil.isNotNull(path) & ObjectUtil.isNotNull(name) & ObjectUtil.isNotNull(newName)) {
            File file = new File(path + "/" + name);
            File newFile = new File(path + "/" + newName);
            file.renameTo(newFile);
            return true;
        }
        return false;
    }

    public static void createTextFile(String pathName, String content) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Creating file...");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pathName: " + pathName));
            LOG.debug((Object)("content: " + content));
        }
        ArrayList<String> line = new ArrayList<String>(1);
        line.add(content);
        FileUtil.writeLines(new File(pathName), line);
    }

    public static void createTextFile(String pathName, List<String> content) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Creating file...");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("pathName: " + pathName));
            LOG.debug((Object)("content: " + content));
        }
        FileUtil.writeLines(new File(pathName), content);
    }

    public static InputStream streamFromClasspath(String classpath) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(classpath);
    }
}

