/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jrimum.utilix.Exceptions;

public final class Objects {
    private Objects() {
        Exceptions.throwIllegalStateException("Instancia\u00e7\u00e3o n\u00e3o permitida!");
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return object != null;
    }

    public static boolean exists(Object object) {
        return object != null;
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            Exceptions.throwIllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            Exceptions.throwIllegalArgumentException(message);
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            Exceptions.throwIllegalStateException();
        }
    }

    public static void checkState(boolean expression, String message) {
        if (!expression) {
            Exceptions.throwIllegalStateException(message);
        }
    }

    public static void checkNull(Object object, String message) {
        if (object != null) {
            Exceptions.throwIllegalArgumentException(message);
        }
    }

    public static void checkNull(Object object) {
        Objects.checkNull(object, "Objeto n\u00e3o nulo! Valor [ " + object + " ].");
    }

    public static void checkNotNull(Object object, String message) {
        if (object == null) {
            Exceptions.throwIllegalArgumentException(message);
        }
    }

    public static void checkNotNull(Object object) {
        Objects.checkNotNull(object, "Objeto nulo!");
    }

    public static <T> T whenNull(Object object, Object defaultValue) {
        return (T)(object != null ? object : defaultValue);
    }

    public static <T> T whenNull(Object object, Object defaultValue, Object notDefaultValue) {
        return (T)(object == null ? defaultValue : notDefaultValue);
    }

    public static String toString(Object obj) {
        return "JRimumObject: " + ToStringBuilder.reflectionToString((Object)obj);
    }
}

