/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.utilix;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.SimpleBookmark;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jrimum.utilix.ObjectUtil;
import org.jrimum.utilix.RectanglePDF;

public class PDFUtil {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOG = Logger.getLogger(PDFUtil.class);

    public static RectanglePDF changeField2Image(PdfStamper stamper, float[] positions, Image image) throws DocumentException {
        RectanglePDF rect = new RectanglePDF(positions);
        return PDFUtil.changeField2Image(stamper, rect, image);
    }

    public static RectanglePDF changeField2Image(PdfStamper stamper, RectanglePDF rect, Image image) throws DocumentException {
        image.scaleAbsolute(rect.getWidth(), rect.getHeight());
        image.setAbsolutePosition(rect.getLowerLeftX() + (rect.getWidth() - image.getScaledWidth()) / 2.0f, rect.getLowerLeftY() + (rect.getHeight() - image.getScaledHeight()) / 2.0f);
        stamper.getOverContent(rect.getPage()).addImage(image);
        return rect;
    }

    public static byte[] mergeFiles(List<byte[]> pdfFiles) {
        byte[] bytes = null;
        if (ObjectUtil.isNotNull(pdfFiles) && !pdfFiles.isEmpty()) {
            int pageOffset = 0;
            boolean first = true;
            ArrayList master = null;
            Document document = null;
            PdfCopy writer = null;
            ByteArrayOutputStream byteOS = null;
            try {
                byteOS = new ByteArrayOutputStream();
                master = new ArrayList();
                for (byte[] doc : pdfFiles) {
                    if (!ObjectUtil.isNotNull(doc)) continue;
                    PdfReader reader = new PdfReader(doc);
                    if (reader.isEncrypted()) {
                        reader = new PdfReader(doc, "".getBytes());
                    }
                    reader.consolidateNamedDestinations();
                    int n = reader.getNumberOfPages();
                    List bookmarks = SimpleBookmark.getBookmark((PdfReader)reader);
                    if (ObjectUtil.isNotNull(bookmarks)) {
                        if (pageOffset != 0) {
                            SimpleBookmark.shiftPageNumbers((List)bookmarks, (int)pageOffset, null);
                        }
                        master.addAll(bookmarks);
                    }
                    pageOffset += n;
                    if (first) {
                        document = new Document(reader.getPageSizeWithRotation(1));
                        writer = new PdfCopy(document, (OutputStream)byteOS);
                        document.addAuthor("JRimum Group");
                        document.addSubject("JRimum Merged Document");
                        document.addCreator("JRimum Utilix");
                        document.open();
                        first = false;
                    }
                    int i = 0;
                    while (i < n) {
                        PdfImportedPage page = writer.getImportedPage(reader, ++i);
                        writer.addPage(page);
                    }
                }
                if (master.size() > 0) {
                    writer.setOutlines(master);
                }
                if (ObjectUtil.isNotNull(document)) {
                    document.close();
                }
                bytes = byteOS.toByteArray();
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        }
        return bytes;
    }
}

