/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.ConfiguracaoJRimum;
import org.jrimum.utilix.ObjectUtil;
import org.jrimum.utilix.Objects;
import org.jrimum.vallia.AbstractDigitoVerificador;
import org.jrimum.vallia.CNPJDV;
import org.jrimum.vallia.CNPJValidator;
import org.jrimum.vallia.CPFDV;
import org.jrimum.vallia.CPFValidator;

public abstract class AbstractCPRFValidator {
    private static final long serialVersionUID = -3107505512223559948L;
    protected StringBuilder codigoDoCadastro;
    protected AbstractDigitoVerificador digitoVerificador;
    private static final String REGEX_CPF = "(\\d{3}\\.\\d{3}\\.\\d{3}\\-\\d{2})|(\\d{11})";
    private static final String REGEX_CNPJ = "(\\d{2}\\.\\d{3}\\.\\d{3}\\/\\d{4}\\-\\d{2})|(\\d{14})";
    private static final String REGEX_CADASTRO = "\\d{3,14}";
    private TipoDeCPRF tipoDeCadastro;

    public abstract boolean isValido();

    protected abstract void removeFormatacao();

    public static AbstractCPRFValidator create(String codigoDoCadastro) throws IllegalArgumentException {
        AbstractCPRFValidator validatorCPRF = null;
        validatorCPRF = AbstractCPRFValidator.create(AbstractCPRFValidator.selectTipoDeCadastro(codigoDoCadastro));
        validatorCPRF.codigoDoCadastro = new StringBuilder(codigoDoCadastro);
        validatorCPRF.removeFormatacao();
        return validatorCPRF;
    }

    public static AbstractCPRFValidator create(TipoDeCPRF tipoDeCadastro) {
        AbstractCPRFValidator validatorCPRF = null;
        if (!Objects.isNotNull(tipoDeCadastro)) {
            throw new IllegalArgumentException("Tipo de Cadastro [ " + tipoDeCadastro + " ] nulo !");
        }
        validatorCPRF = tipoDeCadastro.getAutenticador();
        validatorCPRF.tipoDeCadastro = tipoDeCadastro;
        return validatorCPRF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TipoDeCPRF selectTipoDeCadastro(String codigoDoCadastro) throws IllegalArgumentException {
        TipoDeCPRF tipo = null;
        if (StringUtils.isNotBlank((CharSequence)codigoDoCadastro)) {
            if (Pattern.matches(REGEX_CPF, codigoDoCadastro)) {
                return TipoDeCPRF.CPF;
            }
            if (Pattern.matches(REGEX_CNPJ, codigoDoCadastro)) {
                return TipoDeCPRF.CNPJ;
            }
        }
        if (!ConfiguracaoJRimum.falharEmCPRFInvalido) return tipo;
        throw new IllegalArgumentException("O c\u00f3digo de cadastro [ " + codigoDoCadastro + " ] n\u00e3o est\u00e1 em um formatador v\u00e1lido !");
    }

    public static boolean isParametrosValidos(String codigoDoCadastro, TipoDeCPRF tipoDeCadastro) throws IllegalArgumentException {
        boolean isValido = false;
        if (Objects.isNotNull(codigoDoCadastro) && Objects.isNotNull(tipoDeCadastro)) {
            if (!Pattern.matches(REGEX_CADASTRO, codigoDoCadastro)) {
                throw new IllegalArgumentException("O cadastro est\u00e1 em um tamanho incorreto ou n\u00e3o exsite: [ " + codigoDoCadastro + " ]");
            }
        } else {
            throw new IllegalArgumentException("O tipo de cadastro est\u00e1 incorreto: [ " + tipoDeCadastro + " ] ou o cadastro n\u00e3o exsite: [ " + codigoDoCadastro + " ]");
        }
        isValido = true;
        return isValido;
    }

    public String getCodigoDoCadastro() {
        return this.codigoDoCadastro.toString();
    }

    public boolean isFisica() {
        return this instanceof CPFValidator;
    }

    public boolean isJuridica() {
        return this instanceof CNPJValidator;
    }

    public static enum TipoDeCPRF implements Serializable
    {
        CPF,
        CNPJ;


        public AbstractCPRFValidator getAutenticador() {
            AbstractCPRFValidator validador = null;
            switch (this) {
                case CPF: {
                    validador = new CPFValidator();
                    validador.digitoVerificador = new CPFDV();
                    break;
                }
                case CNPJ: {
                    validador = new CNPJValidator();
                    validador.digitoVerificador = new CNPJDV();
                }
            }
            return validador;
        }

        public String toString() {
            return ObjectUtil.toString(this);
        }
    }
}

