/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.Filler;
import org.jrimum.vallia.AbstractDigitoVerificador;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

public class BoletoLinhaDigitavelDV
extends AbstractDigitoVerificador {
    private static final long serialVersionUID = -9177413216786384292L;
    private static final Modulo modulo10 = new Modulo(TipoDeModulo.MODULO10);
    private static final String REGEX_CAMPO = "(\\d{9})|(\\d{10})|(\\d{5})\\.(\\d{4})|(\\d{5})\\.(\\d{5})";

    @Override
    public int calcule(long numero) {
        return this.calcule(Filler.ZERO_LEFT.fill(String.valueOf(numero), 10));
    }

    @Override
    public int calcule(String numero) throws IllegalArgumentException {
        int dv = 0;
        int resto = 0;
        if (StringUtils.isNotBlank((CharSequence)numero) && Pattern.matches(REGEX_CAMPO, numero)) {
            resto = modulo10.calcule(numero = StringUtils.replaceChars((String)numero, (String)".", (String)""));
            if (resto != 0) {
                dv = modulo10.valor() - resto;
            }
        } else {
            throw new IllegalArgumentException("O campo [ " + numero + " ] da linha digit\u00e1vel deve conter apenas n\u00fameros com 9 ou 10 d\u00edgitos !");
        }
        return dv;
    }
}

