/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.Filler;
import org.jrimum.vallia.AbstractDigitoVerificador;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

public class CNPJDV
extends AbstractDigitoVerificador {
    private static final long serialVersionUID = -4702398145481452503L;
    private static final int LIMITE_MINIMO = 2;
    private static final int LIMITE_MAXIMO = 9;
    private static final String REGEX_CNPJ_DV = "\\d{12}";
    private static final String REGEX_CNPJ_DV_FORMATTED = "\\d{2}\\.\\d{3}\\.\\d{3}\\/\\d{4}";

    @Override
    public int calcule(long numero) {
        return this.calcule(Filler.ZERO_LEFT.fill(String.valueOf(numero), 12));
    }

    @Override
    public int calcule(String numero) throws IllegalArgumentException {
        int dv2;
        int dv1;
        block3: {
            block2: {
                dv1 = 0;
                dv2 = 0;
                boolean isFormatoValido = false;
                if (!StringUtils.isNotBlank((CharSequence)numero)) break block2;
                boolean bl = isFormatoValido = Pattern.matches(REGEX_CNPJ_DV, numero) || Pattern.matches(REGEX_CNPJ_DV_FORMATTED, numero);
                if (isFormatoValido) break block3;
            }
            throw new IllegalArgumentException("O CNPJ [ " + numero + " ] deve conter apenas n\u00fameros, sendo eles no formato ##.###.###/#### ou ############ !");
        }
        numero = StringUtils.replaceChars((String)numero, (String)".", (String)"");
        numero = StringUtils.replaceChars((String)numero, (String)"/", (String)"");
        dv1 = this.calculeDigito(numero);
        dv2 = this.calculeDigito(numero + dv1);
        return Integer.parseInt("" + dv1 + dv2);
    }

    private int calculeDigito(String numero) throws IllegalArgumentException {
        int dv = 0;
        int resto = 0;
        resto = Modulo.calculeMod11(numero, 2, 9);
        if (resto >= 2) {
            dv = TipoDeModulo.MODULO11.valor() - resto;
        }
        return dv;
    }
}

