/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jrimum.texgit.Filler;
import org.jrimum.vallia.AbstractDigitoVerificador;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

public class CPFDV
extends AbstractDigitoVerificador {
    private static final long serialVersionUID = 2059692008894172695L;
    private static final int LIMITE_MINIMO = 2;
    private static final String REGEX_CPF_DV = "\\d{9}";
    private static final String REGEX_CPF_DV_FORMATTED = "\\d{3}\\.\\d{3}\\.\\d{3}";

    @Override
    public int calcule(long numero) {
        return this.calcule(Filler.ZERO_LEFT.fill(String.valueOf(numero), 9));
    }

    @Override
    public int calcule(String numero) throws IllegalArgumentException {
        int dv2;
        int dv1;
        block3: {
            block2: {
                dv1 = 0;
                dv2 = 0;
                boolean isFormatoValido = false;
                if (!StringUtils.isNotBlank((CharSequence)numero)) break block2;
                boolean bl = isFormatoValido = Pattern.matches(REGEX_CPF_DV, numero) || Pattern.matches(REGEX_CPF_DV_FORMATTED, numero);
                if (isFormatoValido) break block3;
            }
            throw new IllegalArgumentException("O CPF [ " + numero + " ] deve conter apenas n\u00fameros, sendo eles no formato ###.###.### ou ######### !");
        }
        numero = StringUtils.replaceChars((String)numero, (String)".", (String)"");
        dv1 = this.calcule(numero, 10);
        dv2 = this.calcule(numero + dv1, 11);
        return Integer.parseInt("" + dv1 + dv2);
    }

    private int calcule(String numero, int limiteMaximoDoModulo) throws IllegalArgumentException {
        int dv = 0;
        int resto = 0;
        resto = Modulo.calculeMod11(numero, 2, limiteMaximoDoModulo);
        if (resto >= 2) {
            dv = TipoDeModulo.MODULO11.valor() - resto;
        }
        return dv;
    }
}

