/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import org.jrimum.vallia.AbstractCPRFValidator;

public class CPFValidator
extends AbstractCPRFValidator {
    private static final long serialVersionUID = 7284156043760247784L;

    @Override
    public boolean isValido() {
        String cpf = this.getCodigoDoCadastro();
        boolean isValido = this.isValidoCpf(cpf);
        return isValido;
    }

    protected boolean isValidoCpf(String cpf) throws NumberFormatException, IllegalArgumentException {
        boolean isValido = false;
        int dv = 0;
        int dvCalculado = -1;
        dv = Integer.parseInt(cpf.substring(9, 11));
        dvCalculado = this.digitoVerificador.calcule(cpf.substring(0, 9));
        isValido = dvCalculado >= 0 && dv == dvCalculado;
        return isValido;
    }

    @Override
    protected void removeFormatacao() {
        String codigo = this.getCodigoDoCadastro();
        codigo = codigo.replace(".", "");
        codigo = codigo.replace("-", "");
        this.codigoDoCadastro.delete(0, this.codigoDoCadastro.length());
        this.codigoDoCadastro.append(codigo);
    }
}

