/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.vallia.AbstractDigitoVerificador;
import org.jrimum.vallia.Modulo;

public class CodigoDeCompensacaoBancosBACENDV
extends AbstractDigitoVerificador {
    private static final long serialVersionUID = -5250684561237486022L;
    public static final int LIMITE_MINIMO = 1;
    public static final int LIMITE_MAXIMO = 999;
    private static final String MSG = "O c\u00f3digo de compensa\u00e7\u00e3o do banco deve ser um n\u00famero entre 1 e 999.";

    @Override
    public int calcule(String numero) {
        if (!this.isCodigoValido(numero)) {
            throw new IllegalArgumentException(MSG);
        }
        return this.calcule(Integer.valueOf(numero.trim()));
    }

    public int calcule(int numero) {
        return this.calcule((long)numero);
    }

    @Override
    public int calcule(long numero) {
        int dv = -1;
        if (!this.isCodigoValido(numero)) {
            throw new IllegalArgumentException(MSG);
        }
        int soma = Modulo.calculeSomaSequencialMod11(String.valueOf(numero), 2, 9);
        dv = (soma *= 10) % 11;
        dv = dv == 10 ? 0 : dv;
        return dv;
    }

    public boolean isCodigoValido(String codigo) {
        boolean codigoValido = false;
        if (StringUtils.isNotBlank((CharSequence)codigo) && StringUtils.isNumeric((CharSequence)codigo)) {
            codigoValido = this.isCodigoValido(Integer.valueOf(codigo.trim()));
        }
        return codigoValido;
    }

    public boolean isCodigoValido(int codigo) {
        return this.isCodigoValido((long)codigo);
    }

    public boolean isCodigoValido(long codigo) {
        return codigo >= 1L && codigo <= 999L;
    }
}

