/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.vallia.AbstractDigitoVerificador;
import org.jrimum.vallia.Modulo;
import org.jrimum.vallia.TipoDeModulo;

public class GuiaCodigoDeBarrasDV
extends AbstractDigitoVerificador {
    private static final long serialVersionUID = -560089440368821000L;
    private static final int TAMANHO_SEM_DV = 43;
    private Modulo modulo;

    public GuiaCodigoDeBarrasDV(Modulo modulo) {
        this.modulo = modulo;
    }

    @Override
    public int calcule(String numero) throws IllegalArgumentException {
        int dv = 0;
        int resto = 0;
        if (StringUtils.isNotBlank((CharSequence)numero) && StringUtils.isNumeric((CharSequence)numero) && numero.length() == 43) {
            resto = this.modulo.calcule(numero);
            if (this.modulo.getMod() == TipoDeModulo.MODULO11) {
                dv = resto == 0 || resto == 1 || resto == 10 ? 1 : this.modulo.valor() - resto;
            } else if (this.modulo.getMod() == TipoDeModulo.MODULO10) {
                dv = resto == 0 || resto == 10 ? 0 : this.modulo.valor() - resto;
            }
        } else {
            throw new IllegalArgumentException("O c\u00f3digo de barras [ " + numero + " ] deve conter apenas n\u00fameros e 43 caracteres.");
        }
        return dv;
    }
}

