/*
 * Decompiled with CFR 0.152.
 */
package org.jrimum.vallia;

import org.apache.commons.lang3.StringUtils;
import org.jrimum.utilix.ObjectUtil;
import org.jrimum.vallia.TipoDeModulo;

public class Modulo {
    private static final long serialVersionUID = -3612368544258125201L;
    private static final String O_ARGUMENTO_DEVE_CONTER_APENAS_NUMEROS = "O argumento deve conter apenas n\u00fameros !";
    public static final int MOD10 = TipoDeModulo.MODULO10.valor();
    public static final int MOD11 = TipoDeModulo.MODULO11.valor();
    private TipoDeModulo mod;
    private int limiteMaximo;
    private int limiteMinimo;

    public Modulo(TipoDeModulo mod) {
        if (ObjectUtil.isNotNull(mod, "modulo")) {
            this.mod = mod;
            this.initDefault();
        }
    }

    public Modulo(TipoDeModulo mod, int limiteMaximo, int limiteMinimo) {
        if (ObjectUtil.isNotNull(mod, "modulo")) {
            this.limiteMaximo = limiteMaximo;
            this.limiteMinimo = limiteMinimo;
            this.mod = mod;
        }
    }

    public int valor() {
        switch (this.mod) {
            case MODULO10: {
                return TipoDeModulo.MODULO10.valor();
            }
            case MODULO11: {
                return TipoDeModulo.MODULO11.valor();
            }
        }
        return -1;
    }

    public static int calculeMod11(long numero, int limiteMin, int limiteMax) {
        return Modulo.calculeMod11(String.valueOf(numero), limiteMin, limiteMax);
    }

    public static int calculeMod11(String numero, int limiteMin, int limiteMax) throws IllegalArgumentException {
        return Modulo.calculeSomaSequencialMod11(numero, limiteMin, limiteMax) % 11;
    }

    public static int calculeSomaSequencialMod11(String numero, int limiteMin, int limiteMax) throws IllegalArgumentException {
        int peso = 0;
        int soma = 0;
        if (StringUtils.isNotBlank((CharSequence)numero) && StringUtils.isNumeric((CharSequence)numero)) {
            StringBuilder sb = new StringBuilder(numero);
            sb.reverse();
            peso = limiteMin;
            for (char c : sb.toString().toCharArray()) {
                soma += peso * Character.getNumericValue(c);
                if (++peso <= limiteMax) continue;
                peso = limiteMin;
            }
        } else {
            throw new IllegalArgumentException(O_ARGUMENTO_DEVE_CONTER_APENAS_NUMEROS);
        }
        return soma;
    }

    public static int calculeMod10(long numero, int limiteMin, int limiteMax) {
        return Modulo.calculeMod10(String.valueOf(numero), limiteMin, limiteMax);
    }

    public static int calculeMod10(String numero, int limiteMin, int limiteMax) throws IllegalArgumentException {
        return Modulo.calculeSomaSequencialMod10(numero, limiteMin, limiteMax) % 10;
    }

    public static int calculeSomaSequencialMod10(String numero, int limiteMin, int limiteMax) throws IllegalArgumentException {
        int produto = 0;
        int peso = 0;
        int soma = 0;
        if (StringUtils.isNotBlank((CharSequence)numero) && StringUtils.isNumeric((CharSequence)numero)) {
            StringBuilder sb = new StringBuilder(numero);
            sb.reverse();
            peso = limiteMax;
            for (char c : sb.toString().toCharArray()) {
                produto = peso * Character.getNumericValue(c);
                if (produto > 9) {
                    soma += produto / 10;
                    soma += produto % 10;
                } else {
                    soma += produto;
                }
                peso = peso == limiteMax ? limiteMin : limiteMax;
            }
        } else {
            throw new IllegalArgumentException(O_ARGUMENTO_DEVE_CONTER_APENAS_NUMEROS);
        }
        return soma;
    }

    public int calcule(String numero) throws IllegalArgumentException {
        int modulo = 0;
        switch (this.mod) {
            case MODULO10: {
                modulo = Modulo.calculeMod10(numero, this.getLimiteMinimo(), this.getLimiteMaximo());
                break;
            }
            case MODULO11: {
                modulo = Modulo.calculeMod11(numero, this.getLimiteMinimo(), this.getLimiteMaximo());
            }
        }
        return modulo;
    }

    public int calcule(long numero) {
        return this.calcule(String.valueOf(numero));
    }

    private void initDefault() {
        switch (this.mod) {
            case MODULO10: {
                this.setLimiteMinimo(1);
                this.setLimiteMaximo(2);
                break;
            }
            case MODULO11: {
                this.setLimiteMinimo(2);
                this.setLimiteMaximo(9);
            }
        }
    }

    public int getLimiteMaximo() {
        return this.limiteMaximo;
    }

    public void setLimiteMaximo(int limiteMaximo) {
        this.limiteMaximo = limiteMaximo;
    }

    public int getLimiteMinimo() {
        return this.limiteMinimo;
    }

    public void setLimiteMinimo(int limiteMinimo) {
        this.limiteMinimo = limiteMinimo;
    }

    public TipoDeModulo getMod() {
        return this.mod;
    }

    public void setMod(TipoDeModulo mod) {
        this.mod = mod;
    }

    public String toString() {
        return ObjectUtil.toString(this);
    }
}

