/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.api.internals;

import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.ReadyRemit;
import com.brightwell.readyremit.sdk.internal.api.ApiError;
import com.brightwell.readyremit.sdk.internal.api.ApiErrors;
import com.brightwell.readyremit.sdk.internal.api.ApiResult;
import com.brightwell.readyremit.sdk.internal.api.NetworkError;
import com.brightwell.readyremit.sdk.internal.api.ProtocolError;
import com.brightwell.readyremit.sdk.internal.api.Success;
import com.brightwell.readyremit.sdk.internal.api.TokenInvalid;
import com.brightwell.readyremit.sdk.internal.api.UnexpectedError;
import com.squareup.moshi.JsonDataException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002BC\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0002H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/brightwell/readyremit/sdk/internal/api/internals/ApiCall;", "T", "Lretrofit2/Call;", "Lcom/brightwell/readyremit/sdk/internal/api/ApiResult;", "delegate", "errorConvertor", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "", "Lcom/brightwell/readyremit/sdk/internal/api/ApiError;", "singleErrorConverter", "<init>", "(Lretrofit2/Call;Lretrofit2/Converter;Lretrofit2/Converter;)V", "isExecuted", "", "isCanceled", "request", "Lokhttp3/Request;", "timeout", "Lokio/Timeout;", "clone", "execute", "Lretrofit2/Response;", "enqueue", "", "callback", "Lretrofit2/Callback;", "cancel", "coerceResponse", "response", "coerceException", "exception", "", "handleError", "Lcom/brightwell/readyremit/sdk/internal/api/ProtocolError;", "errorProtocol", "sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nApiCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiCall.kt\ncom/brightwell/readyremit/sdk/internal/api/internals/ApiCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class ApiCall<T>
implements Call<ApiResult<T>> {
    @NotNull
    private final Call<T> delegate;
    @NotNull
    private final Converter<ResponseBody, List<ApiError>> errorConvertor;
    @NotNull
    private final Converter<ResponseBody, ApiError> singleErrorConverter;
    public static final int $stable = 8;

    public ApiCall(@NotNull Call<T> delegate, @NotNull Converter<ResponseBody, List<ApiError>> errorConvertor, @NotNull Converter<ResponseBody, ApiError> singleErrorConverter) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(errorConvertor, (String)"errorConvertor");
        Intrinsics.checkNotNullParameter(singleErrorConverter, (String)"singleErrorConverter");
        this.delegate = delegate;
        this.errorConvertor = errorConvertor;
        this.singleErrorConverter = singleErrorConverter;
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    @NotNull
    public Request request() {
        Request request = this.delegate.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request(...)");
        return request;
    }

    @NotNull
    public Timeout timeout() {
        Timeout timeout = this.delegate.timeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"timeout(...)");
        return timeout;
    }

    @NotNull
    public Call<ApiResult<T>> clone() {
        Call call = this.delegate.clone();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"clone(...)");
        return new ApiCall<T>(call, this.errorConvertor, this.singleErrorConverter);
    }

    @NotNull
    public Response<ApiResult<T>> execute() {
        Response response;
        try {
            Response response2 = this.delegate.execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"execute(...)");
            response = Response.success(this.coerceResponse(response2));
        }
        catch (Exception exception) {
            response = Response.success(this.coerceException(exception));
        }
        return response;
    }

    public void enqueue(@NotNull Callback<ApiResult<T>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.delegate.enqueue(new Callback<T>(callback, this){
            final /* synthetic */ Callback<ApiResult<T>> $callback;
            final /* synthetic */ ApiCall<T> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(Call<T> call, Response<T> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                this.$callback.onResponse((Call)this.this$0, Response.success((Object)ApiCall.access$coerceResponse(this.this$0, response)));
            }

            public void onFailure(Call<T> call, Throwable throwable) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$callback.onResponse((Call)this.this$0, Response.success((Object)ApiCall.access$coerceException(this.this$0, throwable)));
            }
        });
    }

    public void cancel() {
        this.delegate.cancel();
    }

    private final ApiResult<T> coerceResponse(Response<T> response) {
        ApiResult apiResult;
        try {
            ReadyRemit.INSTANCE.setRequestIdValue(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)response.headers().values("Request-Id").toString(), (CharSequence)"["), (CharSequence)"]"));
            ReadyRemit.INSTANCE.setResponseErrorCode(String.valueOf(response.code()));
            apiResult = switch (response.code()) {
                case 200 -> {
                    Object it;
                    Object v0 = response.body();
                    if (v0 != null) {
                        it = v0;
                        boolean $i$a$-let-ApiCall$coerceResponse$1 = false;
                        yield new Success<Object>(it);
                    }
                    yield this.handleError(new ProtocolError(null, 1, null));
                }
                case 201 -> {
                    Object it;
                    Object v2 = response.body();
                    if (v2 != null) {
                        it = v2;
                        boolean $i$a$-let-ApiCall$coerceResponse$2 = false;
                        yield new Success<Object>(it);
                    }
                    yield this.handleError(new ProtocolError(null, 1, null));
                }
                case 202 -> {
                    Object it;
                    Object v3 = response.body();
                    if (v3 != null) {
                        it = v3;
                        boolean $i$a$-let-ApiCall$coerceResponse$3 = false;
                        yield new Success<Object>(it);
                    }
                    yield this.handleError(new ProtocolError(null, 1, null));
                }
                case 400 -> {
                    List errors;
                    ResponseBody body;
                    ResponseBody v4 = response.errorBody();
                    if (v4 != null) {
                        ApiErrors v6;
                        body = v4;
                        boolean $i$a$-let-ApiCall$coerceResponse$4 = false;
                        List v5 = (List)this.errorConvertor.convert((Object)body);
                        if (v5 != null) {
                            errors = v5;
                            boolean $i$a$-let-ApiCall$coerceResponse$4$1 = false;
                            v6 = new ApiErrors(errors);
                        } else {
                            v6 = null;
                        }
                        v4 = v6;
                        if (v6 != null) {
                            yield (ApiResult)v4;
                        }
                    }
                    yield this.handleError(new ProtocolError(null, 1, null));
                }
                case 401 -> {
                    ResponseBody body;
                    ResponseBody v7 = response.errorBody();
                    if (v7 != null) {
                        ApiErrors v9;
                        body = v7;
                        boolean $i$a$-let-ApiCall$coerceResponse$5 = false;
                        ApiError v8 = (ApiError)this.singleErrorConverter.convert((Object)body);
                        if (v8 != null) {
                            ApiError error = v8;
                            boolean $i$a$-let-ApiCall$coerceResponse$5$1 = false;
                            v9 = new ApiErrors(CollectionsKt.listOf((Object)error));
                        } else {
                            v9 = null;
                        }
                        v7 = v9;
                        if (v9 != null) {
                            yield (ApiResult)v7;
                        }
                    }
                    yield this.handleError(new ProtocolError(null, 1, null));
                }
                case 403 -> new TokenInvalid(CollectionsKt.emptyList());
                case 500 -> {
                    List errors;
                    ResponseBody body;
                    ResponseBody v10 = response.errorBody();
                    if (v10 != null) {
                        ApiErrors v12;
                        body = v10;
                        boolean $i$a$-let-ApiCall$coerceResponse$6 = false;
                        List v11 = (List)this.errorConvertor.convert((Object)body);
                        if (v11 != null) {
                            errors = v11;
                            boolean $i$a$-let-ApiCall$coerceResponse$6$1 = false;
                            v12 = new ApiErrors(errors);
                        } else {
                            v12 = null;
                        }
                        v10 = v12;
                        if (v12 != null) {
                            yield (ApiResult)v10;
                        }
                    }
                    yield this.handleError(new ProtocolError(null, 1, null));
                }
                default -> this.handleError(new ProtocolError(null, 1, null));
            };
        }
        catch (Exception exception) {
            apiResult = this.coerceException(exception);
        }
        return apiResult;
    }

    private final ApiResult<T> coerceException(Throwable exception) {
        Throwable throwable = exception;
        return throwable instanceof SocketException || throwable instanceof SocketTimeoutException ? (ApiResult)new NetworkError(exception) : (throwable instanceof JsonDataException ? (ApiResult)this.handleError(new ProtocolError(exception)) : (ApiResult)new UnexpectedError(exception));
    }

    private final ProtocolError<T> handleError(ProtocolError<T> errorProtocol) {
        Log.e((String)"PROTOCOL ERROR ", (String)errorProtocol.toString());
        return errorProtocol;
    }

    public static final /* synthetic */ ApiResult access$coerceResponse(ApiCall $this, Response response) {
        return $this.coerceResponse(response);
    }

    public static final /* synthetic */ ApiResult access$coerceException(ApiCall $this, Throwable exception) {
        return $this.coerceException(exception);
    }
}

