/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.core.domain.ErrorType;
import com.brightwell.readyremit.sdk.core.domain.ReadyRemitErrorMapper;
import com.brightwell.readyremit.sdk.core.domain.RrError;
import com.brightwell.readyremit.sdk.core.domain.UiString;
import com.brightwell.readyremit.sdk.internal.api.ApiError;
import com.brightwell.readyremit.sdk.internal.api.CustomException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0011\u0018\u00002\u00020\u0001:\u0001\u001aB7\b\u0007\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J$\u0010\u0015\u001a\u0004\u0018\u0001H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0082\b\u00a2\u0006\u0002\u0010\u0019R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl;", "Lcom/brightwell/readyremit/sdk/core/domain/ReadyRemitErrorMapper;", "httpErrorMapper", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "", "Lcom/brightwell/readyremit/sdk/internal/api/ApiError;", "singleHttpErrorMapper", "<init>", "(Lretrofit2/Converter;Lretrofit2/Converter;)V", "map", "Lcom/brightwell/readyremit/sdk/core/domain/RrError;", "error", "", "mapHttpErrorMessage", "Lcom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl$ApiErrorDto;", "Lretrofit2/HttpException;", "getHttpResponseRequestId", "", "headers", "Lokhttp3/Headers;", "expressionOrNull", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ApiErrorDto", "sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReadyRemitErrorMapperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadyRemitErrorMapperImpl.kt\ncom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n118#1,4:132\n118#1,4:136\n1#2:131\n*S KotlinDebug\n*F\n+ 1 ReadyRemitErrorMapperImpl.kt\ncom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl\n*L\n86#1:132,4\n91#1:136,4\n*E\n"})
public class ReadyRemitErrorMapperImpl
implements ReadyRemitErrorMapper {
    @NotNull
    private final Converter<ResponseBody, List<ApiError>> httpErrorMapper;
    @NotNull
    private final Converter<ResponseBody, ApiError> singleHttpErrorMapper;
    public static final int $stable = 8;

    @Inject
    public ReadyRemitErrorMapperImpl(@NotNull Converter<ResponseBody, List<ApiError>> httpErrorMapper, @NotNull Converter<ResponseBody, ApiError> singleHttpErrorMapper) {
        Intrinsics.checkNotNullParameter(httpErrorMapper, (String)"httpErrorMapper");
        Intrinsics.checkNotNullParameter(singleHttpErrorMapper, (String)"singleHttpErrorMapper");
        this.httpErrorMapper = httpErrorMapper;
        this.singleHttpErrorMapper = singleHttpErrorMapper;
    }

    @Override
    @NotNull
    public RrError map(@NotNull Throwable error) {
        RrError rrError;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (throwable instanceof HttpException) {
            String string2;
            ApiErrorDto apiErrorDto = this.mapHttpErrorMessage((HttpException)error);
            String string3 = String.valueOf(((HttpException)error).code());
            String string4 = apiErrorDto.getMessage();
            Response response = ((HttpException)error).response();
            if (response != null && (response = response.headers()) != null) {
                Response it = response;
                boolean bl = false;
                string2 = this.getHttpResponseRequestId((Headers)it);
            } else {
                string2 = null;
            }
            String string5 = string2;
            HttpException httpException = (HttpException)error;
            ErrorType.API aPI = new ErrorType.API(apiErrorDto.getCode());
            rrError = new RrError(string3, string4, null, string5, aPI, (Throwable)httpException, 4, null);
        } else if (throwable instanceof SocketTimeoutException) {
            String string6 = error.getMessage();
            UiString uiString = new UiString(R.string.rrm_timeout, null, 2, null);
            ErrorType.NETWORK nETWORK = ErrorType.NETWORK.INSTANCE;
            rrError = new RrError(null, string6, uiString, null, nETWORK, null, 32, null);
        } else if (throwable instanceof UnknownHostException) {
            String string7 = error.getMessage();
            UiString uiString = new UiString(R.string.rrm_network_error, null, 2, null);
            ErrorType.NETWORK nETWORK = ErrorType.NETWORK.INSTANCE;
            rrError = new RrError(null, string7, uiString, null, nETWORK, null, 32, null);
        } else if (throwable instanceof IOException) {
            String string8 = error.getMessage();
            ErrorType.NETWORK nETWORK = ErrorType.NETWORK.INSTANCE;
            rrError = new RrError(null, string8, null, null, nETWORK, null, 36, null);
        } else if (throwable instanceof CustomException) {
            String string9 = ((CustomException)error).getCode();
            String string10 = ((CustomException)error).getMessage();
            ErrorType.UNKNOWN uNKNOWN = ErrorType.UNKNOWN.INSTANCE;
            rrError = new RrError(string9, string10, null, null, uNKNOWN, null, 36, null);
        } else {
            rrError = new RrError(null, error.getMessage(), null, null, ErrorType.UNKNOWN.INSTANCE, null, 36, null);
        }
        return rrError;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ApiErrorDto mapHttpErrorMessage(HttpException error) {
        try {
            v0 = error.response();
            v1 = errorB = v0 != null && (v0 = v0.errorBody()) != null && (v0 = v0.source()) != null ? v0.peek() : null;
            source = v1 != null ? Util.readBomAsCharset((BufferedSource)v1, (Charset)Charsets.UTF_8) : null;
            v2 /* !! */  = errorB;
            if (v2 /* !! */  == null) ** GOTO lbl-1000
            v3 = source;
            if (v3 == null) {
                v3 = Charsets.UTF_8;
            }
            if ((v2 /* !! */  = v2 /* !! */ .readString(v3)) != null) {
                v4 = ResponseBody.Companion.create$default((ResponseBody.Companion)ResponseBody.Companion, (String)v2 /* !! */ , null, (int)1, null);
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            v5 = body = v4;
            if (v5 != null) {
                errorBody = v5;
                $i$a$-let-ReadyRemitErrorMapperImpl$mapHttpErrorMessage$1 = false;
                this_$iv = this;
                $i$f$expressionOrNull = false;
                try {
                    $i$a$-expressionOrNull-ReadyRemitErrorMapperImpl$mapHttpErrorMessage$1$1 = false;
                    var10_13 = (List)this.httpErrorMapper.convert((Object)errorBody);
                }
                catch (Throwable e$iv) {
                    var10_13 = null;
                }
                v6 = var10_13;
                if (v6 != null) {
                    apiErrorList = v6;
                    $i$a$-let-ReadyRemitErrorMapperImpl$mapHttpErrorMessage$1$2 = false;
                    return new ApiErrorDto(((ApiError)CollectionsKt.first((List)apiErrorList)).getCode(), ((ApiError)CollectionsKt.first((List)apiErrorList)).trackable().getMessage());
                }
                this_$iv = this;
                $i$f$expressionOrNull = false;
                try {
                    $i$a$-expressionOrNull-ReadyRemitErrorMapperImpl$mapHttpErrorMessage$1$3 = false;
                    var12_20 = (ApiError)this.singleHttpErrorMapper.convert((Object)errorBody);
                }
                catch (Throwable e$iv) {
                    var12_20 = null;
                }
                v7 = var12_20;
                if (v7 != null) {
                    it = v7;
                    $i$a$-let-ReadyRemitErrorMapperImpl$mapHttpErrorMessage$1$4 = false;
                    return new ApiErrorDto(it.getCode(), it.trackable().getMessage());
                }
                return new ApiErrorDto(String.valueOf(error.code()), error.message());
            }
            return new ApiErrorDto(String.valueOf(error.code()), error.message());
        }
        catch (Exception e) {
            return new ApiErrorDto("Error", "Error");
        }
    }

    private final String getHttpResponseRequestId(Headers headers) {
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)headers.values("Request-Id").toString(), (CharSequence)"["), (CharSequence)"]");
    }

    private final <R> R expressionOrNull(Function0<? extends R> block) {
        Object object;
        boolean $i$f$expressionOrNull = false;
        try {
            object = block.invoke();
        }
        catch (Throwable e) {
            object = null;
        }
        return (R)object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl$ApiErrorDto;", "", "code", "", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getMessage", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "sdk_release"})
    private static final class ApiErrorDto {
        @NotNull
        private final String code;
        @Nullable
        private final String message;

        public ApiErrorDto(@NotNull String code, @Nullable String message) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            this.code = code;
            this.message = message;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ApiErrorDto copy(@NotNull String code, @Nullable String message) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            return new ApiErrorDto(code, message);
        }

        public static /* synthetic */ ApiErrorDto copy$default(ApiErrorDto apiErrorDto, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = apiErrorDto.code;
            }
            if ((n & 2) != 0) {
                string3 = apiErrorDto.message;
            }
            return apiErrorDto.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "ApiErrorDto(code=" + this.code + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = this.code.hashCode();
            result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ApiErrorDto)) {
                return false;
            }
            ApiErrorDto apiErrorDto = (ApiErrorDto)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)apiErrorDto.code)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)apiErrorDto.message);
        }
    }
}

