/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.domain.usecase.transfer.quote;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.model.CurrencyBo;
import com.brightwell.readyremit.sdk.core.domain.usecase.transfer.quote.IQuoteAmountRequestFormatter;
import com.brightwell.readyremit.sdk.internal.api.data.QuoteBy;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/QuoteAmountRequestFormatter;", "Lcom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/IQuoteAmountRequestFormatter;", "<init>", "()V", "decimalSeparators", "", "formatAmountToGetQuote", "", "value", "quoteBy", "Lcom/brightwell/readyremit/sdk/internal/api/data/QuoteBy;", "sourceCurrency", "Lcom/brightwell/readyremit/sdk/core/domain/model/CurrencyBo;", "destinationCurrency", "sdk_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nQuoteAmountRequestFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuoteAmountRequestFormatter.kt\ncom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/QuoteAmountRequestFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n2669#2,7:51\n*S KotlinDebug\n*F\n+ 1 QuoteAmountRequestFormatter.kt\ncom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/QuoteAmountRequestFormatter\n*L\n28#1:51,7\n*E\n"})
public final class QuoteAmountRequestFormatter
implements IQuoteAmountRequestFormatter {
    @NotNull
    private final String decimalSeparators;
    public static final int $stable;

    /*
     * WARNING - void declaration
     */
    public QuoteAmountRequestFormatter() {
        void $this$reduce$iv;
        void $this$decimalSeparators_u24lambda_u240;
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        QuoteAmountRequestFormatter quoteAmountRequestFormatter = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{Character.valueOf($this$decimalSeparators_u24lambda_u240.getDecimalSeparator()), Character.valueOf($this$decimalSeparators_u24lambda_u240.getMonetaryDecimalSeparator()), Character.valueOf($this$decimalSeparators_u24lambda_u240.getPatternSeparator()), Character.valueOf($this$decimalSeparators_u24lambda_u240.getGroupingSeparator()), $this$decimalSeparators_u24lambda_u240.getExponentSeparator()};
        Iterable iterable = SetsKt.hashSetOf((Object[])objectArray);
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void symbol;
            Object t = iterator$iv.next();
            Object acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = "" + acc + symbol;
        }
        quoteAmountRequestFormatter.decimalSeparators = accumulator$iv.toString();
    }

    @Override
    public int formatAmountToGetQuote(@NotNull String value, @NotNull QuoteBy quoteBy, @NotNull CurrencyBo sourceCurrency, @NotNull CurrencyBo destinationCurrency) {
        DecimalFormat decimalFormat;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)quoteBy), (String)"quoteBy");
        Intrinsics.checkNotNullParameter((Object)sourceCurrency, (String)"sourceCurrency");
        Intrinsics.checkNotNullParameter((Object)destinationCurrency, (String)"destinationCurrency");
        int decimalPlaces = quoteBy == QuoteBy.SEND_AMOUNT ? sourceCurrency.getDecimalPlaces() : destinationCurrency.getDecimalPlaces();
        DecimalFormat $this$formatAmountToGetQuote_u24lambda_u242 = decimalFormat = new DecimalFormat();
        boolean bl = false;
        $this$formatAmountToGetQuote_u24lambda_u242.setMinimumFractionDigits(decimalPlaces);
        $this$formatAmountToGetQuote_u24lambda_u242.setMaximumFractionDigits(decimalPlaces);
        $this$formatAmountToGetQuote_u24lambda_u242.setGroupingUsed(false);
        $this$formatAmountToGetQuote_u24lambda_u242.setRoundingMode(RoundingMode.DOWN);
        CharSequence charSequence = value;
        Regex regex = new Regex("[" + this.decimalSeparators + "]");
        String string2 = ".";
        Number number = StringsKt.toDoubleOrNull((String)regex.replace(charSequence, string2));
        if (number == null) {
            number = 0;
        }
        String string3 = decimalFormat.format(number);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        CharSequence charSequence2 = string3;
        decimalFormat = new Regex("[" + this.decimalSeparators + "]");
        charSequence = "";
        Integer n = StringsKt.toIntOrNull((String)decimalFormat.replace(charSequence2, (String)charSequence));
        return n != null ? n : 0;
    }
}

