/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.ui;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.INetworkObserver;
import com.brightwell.readyremit.sdk.core.ui.AndroidNetworkObserver;
import com.brightwell.readyremit.sdk.core.ui.IAndroidNetworkObserver;
import com.brightwell.readyremit.sdk.utils.IDispatcherProvider;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0004*\u0001\u0019\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0010\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006\u001c"}, d2={"Lcom/brightwell/readyremit/sdk/core/ui/AndroidNetworkObserver;", "Lcom/brightwell/readyremit/sdk/core/ui/IAndroidNetworkObserver;", "context", "Landroid/content/Context;", "iDispatcherProvider", "Lcom/brightwell/readyremit/sdk/utils/IDispatcherProvider;", "<init>", "(Landroid/content/Context;Lcom/brightwell/readyremit/sdk/utils/IDispatcherProvider;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "validNetworkConnections", "Ljava/util/HashSet;", "Landroid/net/Network;", "Lkotlin/collections/HashSet;", "_status", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/brightwell/readyremit/sdk/core/domain/INetworkObserver$Status;", "status", "Lkotlinx/coroutines/flow/StateFlow;", "getStatus", "()Lkotlinx/coroutines/flow/StateFlow;", "isConnectedToTheInternet", "", "()Z", "networkCallback", "com/brightwell/readyremit/sdk/core/ui/AndroidNetworkObserver$networkCallback$1", "Lcom/brightwell/readyremit/sdk/core/ui/AndroidNetworkObserver$networkCallback$1;", "Companion", "sdk_release"})
@StabilityInferred(parameters=0)
public final class AndroidNetworkObserver
implements IAndroidNetworkObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDispatcherProvider iDispatcherProvider;
    @NotNull
    private ConnectivityManager connectivityManager;
    @NotNull
    private final HashSet<Network> validNetworkConnections;
    @NotNull
    private final MutableStateFlow<INetworkObserver.Status> _status;
    @NotNull
    private final StateFlow<INetworkObserver.Status> status;
    @NotNull
    private final networkCallback.1 networkCallback;
    public static final int $stable = 8;
    @NotNull
    private static final String GOOGLE_URL = "https://clients3.google.com/generate_204";
    @NotNull
    private static final String USER_AGENT = "User-Agent";
    @NotNull
    private static final String ANDROID_USER_AGENT = "Android";
    @NotNull
    private static final String CONNECTION = "Connection";
    @NotNull
    private static final String CONNECTION_CLOSE = "Close";
    private static final int CONNECTION_TIMEOUT = 5000;

    public AndroidNetworkObserver(@NotNull Context context, @NotNull IDispatcherProvider iDispatcherProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)iDispatcherProvider, (String)"iDispatcherProvider");
        this.iDispatcherProvider = iDispatcherProvider;
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
        this.validNetworkConnections = new HashSet();
        this._status = StateFlowKt.MutableStateFlow((Object)((Object)INetworkObserver.Status.Unknown));
        this.status = FlowKt.stateIn((Flow)((Flow)FlowKt.asStateFlow(this._status)), (CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.iDispatcherProvider.main())), (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)((Object)INetworkObserver.Status.Unknown));
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ AndroidNetworkObserver this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(Network network) {
                NetworkCapabilities networkCapability;
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                NetworkCapabilities networkCapabilities = networkCapability = AndroidNetworkObserver.access$getConnectivityManager$p(this.this$0).getNetworkCapabilities(network);
                boolean hasNetworkConnection = networkCapabilities != null ? networkCapabilities.hasCapability(12) : false;
                if (hasNetworkConnection) {
                    this.determineInternetAccess(network);
                }
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                AndroidNetworkObserver.access$getValidNetworkConnections$p(this.this$0).remove(network);
                this.announceNetworkStatus();
            }

            private final void determineInternetAccess(Network network) {
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)AndroidNetworkObserver.access$getIDispatcherProvider$p(this.this$0).io())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, this.this$0, network, null){
                    int label;
                    final /* synthetic */ networkCallback.1 this$0;
                    final /* synthetic */ AndroidNetworkObserver this$1;
                    final /* synthetic */ Network $network;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$network = $network;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (!networkCallback.1.access$thereIsInternetAccess(this.this$0)) return Unit.INSTANCE;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)AndroidNetworkObserver.access$getIDispatcherProvider$p(this.this$1).main()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.$network, this.this$0, null){
                                    int label;
                                    final /* synthetic */ AndroidNetworkObserver this$0;
                                    final /* synthetic */ Network $network;
                                    final /* synthetic */ networkCallback.1 this$1;
                                    {
                                        this.this$0 = $receiver;
                                        this.$network = $network;
                                        this.this$1 = $receiver2;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                AndroidNetworkObserver.access$getValidNetworkConnections$p(this.this$0).add(this.$network);
                                                this.this$1.announceNetworkStatus();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public final void announceNetworkStatus() {
                if (!((Collection)AndroidNetworkObserver.access$getValidNetworkConnections$p(this.this$0)).isEmpty()) {
                    INetworkObserver.Status nextValue$iv;
                    Object prevValue$iv;
                    MutableStateFlow $this$update$iv = AndroidNetworkObserver.access$get_status$p(this.this$0);
                    boolean $i$f$update = false;
                    do {
                        prevValue$iv = $this$update$iv.getValue();
                        INetworkObserver.Status it = (INetworkObserver.Status)((Object)prevValue$iv);
                        boolean bl = false;
                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)((Object)(nextValue$iv = INetworkObserver.Status.Available))));
                } else {
                    INetworkObserver.Status nextValue$iv;
                    Object prevValue$iv;
                    MutableStateFlow $this$update$iv = AndroidNetworkObserver.access$get_status$p(this.this$0);
                    boolean $i$f$update = false;
                    do {
                        prevValue$iv = $this$update$iv.getValue();
                        INetworkObserver.Status it = (INetworkObserver.Status)((Object)prevValue$iv);
                        boolean bl = false;
                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)((Object)(nextValue$iv = INetworkObserver.Status.Unavailable))));
                }
            }

            private final boolean thereIsInternetAccess() {
                boolean bl;
                try {
                    URL url = new URL("https://clients3.google.com/generate_204");
                    URLConnection uRLConnection = url.openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    HttpURLConnection urlC = (HttpURLConnection)uRLConnection;
                    urlC.setRequestProperty("User-Agent", "Android");
                    urlC.setRequestProperty("Connection", "Close");
                    urlC.setConnectTimeout(5000);
                    urlC.connect();
                    bl = urlC.getResponseCode() == 204 && urlC.getContentLength() == 0;
                }
                catch (Exception e) {
                    bl = false;
                }
                return bl;
            }

            public static final /* synthetic */ boolean access$thereIsInternetAccess(networkCallback.1 $this) {
                return $this.thereIsInternetAccess();
            }
        };
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        this.connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    @Override
    @NotNull
    public StateFlow<INetworkObserver.Status> getStatus() {
        return this.status;
    }

    @Override
    public boolean isConnectedToTheInternet() {
        return this.getStatus().getValue() == INetworkObserver.Status.Available;
    }

    public static final /* synthetic */ ConnectivityManager access$getConnectivityManager$p(AndroidNetworkObserver $this) {
        return $this.connectivityManager;
    }

    public static final /* synthetic */ HashSet access$getValidNetworkConnections$p(AndroidNetworkObserver $this) {
        return $this.validNetworkConnections;
    }

    public static final /* synthetic */ IDispatcherProvider access$getIDispatcherProvider$p(AndroidNetworkObserver $this) {
        return $this.iDispatcherProvider;
    }

    public static final /* synthetic */ MutableStateFlow access$get_status$p(AndroidNetworkObserver $this) {
        return $this._status;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/brightwell/readyremit/sdk/core/ui/AndroidNetworkObserver$Companion;", "", "<init>", "()V", "GOOGLE_URL", "", "USER_AGENT", "ANDROID_USER_AGENT", "CONNECTION", "CONNECTION_CLOSE", "CONNECTION_TIMEOUT", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

