/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.api.internals;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.ReadyRemit;
import com.brightwell.readyremit.sdk.environment.Environment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/brightwell/readyremit/sdk/internal/api/internals/RequestInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "getAcceptLanguage", "", "getNewUrl", "Lokhttp3/HttpUrl;", "originalUrl", "buildNewRequest", "Lokhttp3/Request;", "request", "newUrl", "acceptLanguage", "sdk_release"})
@StabilityInferred(parameters=1)
public final class RequestInterceptor
implements Interceptor {
    public static final int $stable;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        String acceptLanguage = this.getAcceptLanguage();
        HttpUrl newUrl = this.getNewUrl(request.url());
        Request newRequest = this.buildNewRequest(request, newUrl, acceptLanguage);
        Response response = chain.proceed(newRequest);
        ReadyRemit.INSTANCE.setRequestIdValue(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)response.headers().values("Request-Id").toString(), (CharSequence)"["), (CharSequence)"]"));
        return response;
    }

    private final String getAcceptLanguage() {
        String string2 = ReadyRemit.Config.Companion.getApiLanguage$sdk_release();
        if (string2 == null) {
            string2 = "en-US";
        }
        String acceptLanguage = StringsKt.contains((CharSequence)string2, (CharSequence)"es", (boolean)true) ? "es-MX" : "en-US";
        return acceptLanguage;
    }

    private final HttpUrl getNewUrl(HttpUrl originalUrl) {
        return Environment.Companion.getShouldRedirectURL$sdk_release() && ReadyRemit.INSTANCE.getEnvironmentUrl() == Environment.PRODUCTION ? HttpUrl.Companion.get("https://api.brightwell.com/") : HttpUrl.Companion.get("https://" + originalUrl.host());
    }

    private final Request buildNewRequest(Request request, HttpUrl newUrl, String acceptLanguage) {
        Request.Builder newRequestBuilder = request.newBuilder().url(newUrl.newBuilder().encodedPath(request.url().encodedPath()).encodedQuery(request.url().encodedQuery()).build()).addHeader("Content-Type", "application/json").addHeader("ACCEPT-LANGUAGE", acceptLanguage).method(request.method(), request.body());
        return newRequestBuilder.build();
    }
}

