/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.new_arch.features.transfer.receipt;

import android.content.ContentValues;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.AndroidImageBitmap_androidKt;
import androidx.compose.ui.graphics.ImageBitmap;
import com.brightwell.readyremit.sdk.new_arch.features.transfer.receipt.IScreenshotGenerator;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\rH\u0016J,\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/brightwell/readyremit/sdk/new_arch/features/transfer/receipt/ScreenshotGenerator;", "Lcom/brightwell/readyremit/sdk/new_arch/features/transfer/receipt/IScreenshotGenerator;", "<init>", "()V", "onScreenshot", "", "context", "Landroid/content/Context;", "bitmap", "Landroidx/compose/ui/graphics/ImageBitmap;", "onSuccess", "Lkotlin/Function0;", "onFailure", "Lkotlin/Function1;", "", "saveReceiptLocally", "outputStream", "Ljava/io/OutputStream;", "sdk_release"})
@StabilityInferred(parameters=1)
public final class ScreenshotGenerator
implements IScreenshotGenerator {
    public static final int $stable;

    @Override
    public void onScreenshot(@NotNull Context context, @NotNull ImageBitmap bitmap, @NotNull Function0<Unit> onSuccess, @NotNull Function1<? super String, Unit> onFailure) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        ContentValues contentValues = new ContentValues();
        contentValues.put("mime_type", "image/png");
        contentValues.put("date_added", Long.valueOf(System.currentTimeMillis() / (long)1000));
        contentValues.put("datetaken", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("relative_path", "Pictures/");
        contentValues.put("is_pending", Boolean.valueOf(true));
        Uri uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        if (uri != null) {
            Uri uri2 = uri;
            boolean bl = false;
            OutputStream outputStream = context.getContentResolver().openOutputStream(uri2);
            if (outputStream != null) {
                OutputStream outputStream2 = outputStream;
                boolean bl2 = false;
                this.saveReceiptLocally(bitmap, outputStream2, onFailure);
                contentValues.put("is_pending", Boolean.valueOf(false));
                context.getContentResolver().update(uri2, contentValues, null, null);
                onSuccess.invoke();
            } else {
                onFailure.invoke((Object)"Error opening output stream");
            }
        } else {
            onFailure.invoke((Object)"Error inserting into External Content URI");
        }
    }

    private final void saveReceiptLocally(ImageBitmap bitmap, OutputStream outputStream, Function1<? super String, Unit> onFailure) {
        try {
            AndroidImageBitmap_androidKt.asAndroidBitmap((ImageBitmap)bitmap).compress(Bitmap.CompressFormat.PNG, 100, outputStream);
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            onFailure.invoke((Object)string2);
        }
    }
}

