/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils;

import com.brightwell.readyremit.sdk.internal.resources.CountryCodes;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0002\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u0006*\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\b\u001a\u00020\u0001*\u0004\u0018\u00010\u00012\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0000\u001a\u000e\u0010\t\u001a\u00020\u0001*\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\n\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u000e\u0010\u000b\u001a\u00020\u0006*\u0004\u0018\u00010\u0001H\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0006*\u00020\u0001H\u0000\u00a8\u0006\u000f"}, d2={"orNull", "", "onlyLetters", "onlyAlphaNumeric", "onlyNumbers", "toMoneyValue", "", "decimalPlaces", "toDisplayDecimal", "iso3ToCountryName", "capitalize", "convertToIntValue", "isAmount", "", "toAmount", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nStringExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringExt.kt\ncom/brightwell/readyremit/sdk/utils/StringExtKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,74:1\n1#2:75\n434#3:76\n507#3,5:77\n*S KotlinDebug\n*F\n+ 1 StringExt.kt\ncom/brightwell/readyremit/sdk/utils/StringExtKt\n*L\n56#1:76\n56#1:77,5\n*E\n"})
public final class StringExtKt {
    @Nullable
    public static final String orNull(@NotNull String $this$orNull) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$orNull, (String)"<this>");
        CharSequence charSequence2 = $this$orNull;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public static final String onlyLetters(@NotNull String $this$onlyLetters) {
        Intrinsics.checkNotNullParameter((Object)$this$onlyLetters, (String)"<this>");
        Regex nonLetters = new Regex("[^a-zA-Z]");
        CharSequence charSequence = $this$onlyLetters;
        String string2 = "";
        return nonLetters.replace(charSequence, string2);
    }

    @NotNull
    public static final String onlyAlphaNumeric(@NotNull String $this$onlyAlphaNumeric) {
        Intrinsics.checkNotNullParameter((Object)$this$onlyAlphaNumeric, (String)"<this>");
        Regex nonAlphaNum = new Regex("[^a-zA-Z0-9]");
        CharSequence charSequence = $this$onlyAlphaNumeric;
        String string2 = "";
        return nonAlphaNum.replace(charSequence, string2);
    }

    @NotNull
    public static final String onlyNumbers(@NotNull String $this$onlyNumbers) {
        Intrinsics.checkNotNullParameter((Object)$this$onlyNumbers, (String)"<this>");
        Regex nonNumers = new Regex("[^0-9]");
        CharSequence charSequence = $this$onlyNumbers;
        String string2 = "";
        return nonNumers.replace(charSequence, string2);
    }

    public static final int toMoneyValue(@Nullable String $this$toMoneyValue, int decimalPlaces) {
        int n;
        try {
            String string2 = $this$toMoneyValue;
            Intrinsics.checkNotNull((Object)string2);
            BigDecimal result = new BigDecimal(string2).movePointRight(decimalPlaces);
            n = result.intValue();
        }
        catch (Exception e) {
            n = 0;
        }
        return n;
    }

    public static /* synthetic */ int toMoneyValue$default(String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return StringExtKt.toMoneyValue(string2, n);
    }

    @NotNull
    public static final String toDisplayDecimal(@Nullable String $this$toDisplayDecimal, int decimalPlaces) {
        String string2;
        try {
            String string3 = $this$toDisplayDecimal;
            Intrinsics.checkNotNull((Object)string3);
            BigDecimal result = new BigDecimal(StringExtKt.onlyNumbers(string3)).movePointLeft(decimalPlaces);
            string2 = result.toString();
        }
        catch (Exception e) {
            string2 = new BigDecimal(0).movePointLeft(decimalPlaces).toString();
        }
        return string2;
    }

    public static /* synthetic */ String toDisplayDecimal$default(String string2, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        return StringExtKt.toDisplayDecimal(string2, n);
    }

    @NotNull
    public static final String iso3ToCountryName(@Nullable String $this$iso3ToCountryName) {
        String string2 = $this$iso3ToCountryName;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return CountryCodes.INSTANCE.getNameForIsoCode(it);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String capitalize(@NotNull String $this$capitalize) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$capitalize, (String)"<this>");
        String string3 = $this$capitalize.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String string4 = StringsKt.replace$default((String)string3, (char)'_', (char)' ', (boolean)false, (int)4, null);
        if (((CharSequence)string4).length() > 0) {
            void it;
            char c = string4.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.titlecase((char)it, (Locale)locale));
            String string5 = string4;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string2 = stringBuilder2.append(string6).toString();
        } else {
            string2 = string4;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int convertToIntValue(@Nullable String $this$convertToIntValue) {
        int n;
        try {
            int n2;
            void $this$filterTo$iv$iv;
            String string2 = $this$convertToIntValue;
            Intrinsics.checkNotNull((Object)string2);
            String $this$filter$iv = StringsKt.replace$default((String)string2, (String)",", (String)".", (boolean)false, (int)4, null);
            boolean $i$f$filter = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n3 = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n3; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(Character.isDigit(it) || it == '.')) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string3 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String input = string3;
            char[] cArray = new char[]{'.'};
            List parts = StringsKt.split$default((CharSequence)input, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 1 || ((CharSequence)parts.get(1)).length() == 0) {
                n2 = Integer.parseInt((String)parts.get(0)) * 100;
            } else if (((String)parts.get(1)).length() > 2) {
                Object e = parts.get(0);
                String string4 = ((String)parts.get(1)).substring(0, 2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                n2 = Integer.parseInt(e + string4);
            } else {
                n2 = Integer.parseInt(parts.get(0) + StringsKt.padEnd((String)((String)parts.get(1)), (int)2, (char)'0'));
            }
            n = n2;
        }
        catch (Exception e) {
            n = 0;
        }
        return n;
    }

    public static final boolean isAmount(@NotNull String $this$isAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$isAmount, (String)"<this>");
        return StringsKt.toIntOrNull((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$this$isAmount, (String)".", (String)"", (boolean)false, (int)4, null), (String)",", (String)"", (boolean)false, (int)4, null)) != null;
    }

    public static final int toAmount(@NotNull String $this$toAmount) {
        Intrinsics.checkNotNullParameter((Object)$this$toAmount, (String)"<this>");
        return Integer.parseInt(StringsKt.replace$default((String)$this$toAmount, (String)".", (String)"", (boolean)false, (int)4, null));
    }
}

