/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.domain.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.model.AdjustmentBo;
import com.brightwell.readyremit.sdk.core.domain.model.CountryBo;
import com.brightwell.readyremit.sdk.core.domain.model.CountryIso3Code;
import com.brightwell.readyremit.sdk.core.domain.model.CurrencyIso3Code;
import com.brightwell.readyremit.sdk.core.domain.model.DeliverySlaBo;
import com.brightwell.readyremit.sdk.core.domain.model.MoneyBo;
import com.brightwell.readyremit.sdk.core.domain.model.TransferMethod;
import com.brightwell.readyremit.sdk.core.domain.usecase.transfer.quote.QuoteAmountRequestFormatter;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001f\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0010\u0015\u001a\u00020\u000e\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0006\u00107\u001a\u000208J\u0006\u00109\u001a\u00020\u0003J\u0006\u0010:\u001a\u00020\u0003J\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\t\u0010<\u001a\u00020\u0005H\u00c6\u0003J\t\u0010=\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010?\u001a\u00020\u0007H\u00c6\u0003J\t\u0010@\u001a\u00020\fH\u00c6\u0003J\t\u0010A\u001a\u00020\u000eH\u00c6\u0003J\t\u0010B\u001a\u00020\u000eH\u00c6\u0003J\t\u0010C\u001a\u00020\u0011H\u00c6\u0003J\u000f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u00c6\u0003J\t\u0010E\u001a\u00020\u000eH\u00c6\u0003J\u000f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u00c6\u0003J\t\u0010G\u001a\u00020\u0018H\u00c6\u0003J\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J\u00a3\u0001\u0010I\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u000e2\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00132\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0003H\u00c7\u0001J\u0013\u0010J\u001a\u0002082\b\u0010K\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010L\u001a\u00020MH\u00d7\u0001J\t\u0010N\u001a\u00020\u0003H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010#R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010*R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010*R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010/R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u001dR\u0011\u00105\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001d\u00a8\u0006O"}, d2={"Lcom/brightwell/readyremit/sdk/core/domain/model/QuoteBo;", "", "quoteHistoryId", "", "destinationCountryISO3Code", "Lcom/brightwell/readyremit/sdk/core/domain/model/CountryIso3Code;", "destinationCurrencyISO3Code", "Lcom/brightwell/readyremit/sdk/core/domain/model/CurrencyIso3Code;", "destinationCountry", "Lcom/brightwell/readyremit/sdk/core/domain/model/CountryBo;", "sourceCurrencyIso3Code", "transferMethod", "Lcom/brightwell/readyremit/sdk/core/domain/model/TransferMethod;", "sendAmount", "Lcom/brightwell/readyremit/sdk/core/domain/model/MoneyBo;", "receiveAmount", "rate", "Ljava/math/BigDecimal;", "adjustments", "", "Lcom/brightwell/readyremit/sdk/core/domain/model/AdjustmentBo;", "totalCost", "disclosures", "deliverySLA", "Lcom/brightwell/readyremit/sdk/core/domain/model/DeliverySlaBo;", "rsp", "<init>", "(Ljava/lang/String;Lcom/brightwell/readyremit/sdk/core/domain/model/CountryIso3Code;Lcom/brightwell/readyremit/sdk/core/domain/model/CurrencyIso3Code;Lcom/brightwell/readyremit/sdk/core/domain/model/CountryBo;Lcom/brightwell/readyremit/sdk/core/domain/model/CurrencyIso3Code;Lcom/brightwell/readyremit/sdk/core/domain/model/TransferMethod;Lcom/brightwell/readyremit/sdk/core/domain/model/MoneyBo;Lcom/brightwell/readyremit/sdk/core/domain/model/MoneyBo;Ljava/math/BigDecimal;Ljava/util/List;Lcom/brightwell/readyremit/sdk/core/domain/model/MoneyBo;Ljava/util/List;Lcom/brightwell/readyremit/sdk/core/domain/model/DeliverySlaBo;Ljava/lang/String;)V", "getQuoteHistoryId", "()Ljava/lang/String;", "getDestinationCountryISO3Code", "()Lcom/brightwell/readyremit/sdk/core/domain/model/CountryIso3Code;", "setDestinationCountryISO3Code", "(Lcom/brightwell/readyremit/sdk/core/domain/model/CountryIso3Code;)V", "getDestinationCurrencyISO3Code", "()Lcom/brightwell/readyremit/sdk/core/domain/model/CurrencyIso3Code;", "getDestinationCountry", "()Lcom/brightwell/readyremit/sdk/core/domain/model/CountryBo;", "getSourceCurrencyIso3Code", "getTransferMethod", "()Lcom/brightwell/readyremit/sdk/core/domain/model/TransferMethod;", "getSendAmount", "()Lcom/brightwell/readyremit/sdk/core/domain/model/MoneyBo;", "getReceiveAmount", "getRate", "()Ljava/math/BigDecimal;", "getAdjustments", "()Ljava/util/List;", "getTotalCost", "getDisclosures", "getDeliverySLA", "()Lcom/brightwell/readyremit/sdk/core/domain/model/DeliverySlaBo;", "getRsp", "formattedExchangeRate", "getFormattedExchangeRate", "isDomesticTransfer", "", "getFormattedSendAmount", "getFormattedReceiveAmount", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "copy", "equals", "other", "hashCode", "", "toString", "sdk_release"})
@StabilityInferred(parameters=0)
public final class QuoteBo {
    @NotNull
    private final String quoteHistoryId;
    @NotNull
    private CountryIso3Code destinationCountryISO3Code;
    @NotNull
    private final CurrencyIso3Code destinationCurrencyISO3Code;
    @Nullable
    private final CountryBo destinationCountry;
    @NotNull
    private final CurrencyIso3Code sourceCurrencyIso3Code;
    @NotNull
    private final TransferMethod transferMethod;
    @NotNull
    private final MoneyBo sendAmount;
    @NotNull
    private final MoneyBo receiveAmount;
    @NotNull
    private final BigDecimal rate;
    @NotNull
    private final List<AdjustmentBo> adjustments;
    @NotNull
    private final MoneyBo totalCost;
    @NotNull
    private final List<String> disclosures;
    @NotNull
    private final DeliverySlaBo deliverySLA;
    @NotNull
    private final String rsp;
    public static final int $stable = 8;

    public QuoteBo(@NotNull String quoteHistoryId, @NotNull CountryIso3Code destinationCountryISO3Code, @NotNull CurrencyIso3Code destinationCurrencyISO3Code, @Nullable CountryBo destinationCountry, @NotNull CurrencyIso3Code sourceCurrencyIso3Code, @NotNull TransferMethod transferMethod, @NotNull MoneyBo sendAmount, @NotNull MoneyBo receiveAmount, @NotNull BigDecimal rate, @NotNull List<AdjustmentBo> adjustments, @NotNull MoneyBo totalCost, @NotNull List<String> disclosures, @NotNull DeliverySlaBo deliverySLA, @NotNull String rsp) {
        Intrinsics.checkNotNullParameter((Object)quoteHistoryId, (String)"quoteHistoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)destinationCountryISO3Code), (String)"destinationCountryISO3Code");
        Intrinsics.checkNotNullParameter((Object)((Object)destinationCurrencyISO3Code), (String)"destinationCurrencyISO3Code");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceCurrencyIso3Code), (String)"sourceCurrencyIso3Code");
        Intrinsics.checkNotNullParameter((Object)transferMethod, (String)"transferMethod");
        Intrinsics.checkNotNullParameter((Object)sendAmount, (String)"sendAmount");
        Intrinsics.checkNotNullParameter((Object)receiveAmount, (String)"receiveAmount");
        Intrinsics.checkNotNullParameter((Object)rate, (String)"rate");
        Intrinsics.checkNotNullParameter(adjustments, (String)"adjustments");
        Intrinsics.checkNotNullParameter((Object)totalCost, (String)"totalCost");
        Intrinsics.checkNotNullParameter(disclosures, (String)"disclosures");
        Intrinsics.checkNotNullParameter((Object)deliverySLA, (String)"deliverySLA");
        Intrinsics.checkNotNullParameter((Object)rsp, (String)"rsp");
        this.quoteHistoryId = quoteHistoryId;
        this.destinationCountryISO3Code = destinationCountryISO3Code;
        this.destinationCurrencyISO3Code = destinationCurrencyISO3Code;
        this.destinationCountry = destinationCountry;
        this.sourceCurrencyIso3Code = sourceCurrencyIso3Code;
        this.transferMethod = transferMethod;
        this.sendAmount = sendAmount;
        this.receiveAmount = receiveAmount;
        this.rate = rate;
        this.adjustments = adjustments;
        this.totalCost = totalCost;
        this.disclosures = disclosures;
        this.deliverySLA = deliverySLA;
        this.rsp = rsp;
    }

    @NotNull
    public final String getQuoteHistoryId() {
        return this.quoteHistoryId;
    }

    @NotNull
    public final CountryIso3Code getDestinationCountryISO3Code() {
        return this.destinationCountryISO3Code;
    }

    public final void setDestinationCountryISO3Code(@NotNull CountryIso3Code countryIso3Code) {
        Intrinsics.checkNotNullParameter((Object)((Object)countryIso3Code), (String)"<set-?>");
        this.destinationCountryISO3Code = countryIso3Code;
    }

    @NotNull
    public final CurrencyIso3Code getDestinationCurrencyISO3Code() {
        return this.destinationCurrencyISO3Code;
    }

    @Nullable
    public final CountryBo getDestinationCountry() {
        return this.destinationCountry;
    }

    @NotNull
    public final CurrencyIso3Code getSourceCurrencyIso3Code() {
        return this.sourceCurrencyIso3Code;
    }

    @NotNull
    public final TransferMethod getTransferMethod() {
        return this.transferMethod;
    }

    @NotNull
    public final MoneyBo getSendAmount() {
        return this.sendAmount;
    }

    @NotNull
    public final MoneyBo getReceiveAmount() {
        return this.receiveAmount;
    }

    @NotNull
    public final BigDecimal getRate() {
        return this.rate;
    }

    @NotNull
    public final List<AdjustmentBo> getAdjustments() {
        return this.adjustments;
    }

    @NotNull
    public final MoneyBo getTotalCost() {
        return this.totalCost;
    }

    @NotNull
    public final List<String> getDisclosures() {
        return this.disclosures;
    }

    @NotNull
    public final DeliverySlaBo getDeliverySLA() {
        return this.deliverySLA;
    }

    @NotNull
    public final String getRsp() {
        return this.rsp;
    }

    @NotNull
    public final String getFormattedExchangeRate() {
        String string2 = this.rate.toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPlainString(...)");
        return string2;
    }

    public final boolean isDomesticTransfer() {
        return CountryIso3Code.USA == this.destinationCountryISO3Code || this.sourceCurrencyIso3Code == this.destinationCurrencyISO3Code;
    }

    @NotNull
    public final String getFormattedSendAmount() {
        char decimalSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getDecimalSeparator();
        BigDecimal bigDecimal = BigDecimal.valueOf(this.sendAmount.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        String string2 = bigDecimal.movePointLeft(this.sendAmount.getCurrency().getDecimalPlaces()).stripTrailingZeros().toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPlainString(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("[" + QuoteAmountRequestFormatter.Companion.getDecimalSeparators() + "]");
        String string3 = String.valueOf(decimalSeparator);
        return regex.replace(charSequence, string3);
    }

    @NotNull
    public final String getFormattedReceiveAmount() {
        char decimalSeparator = DecimalFormatSymbols.getInstance(Locale.getDefault()).getDecimalSeparator();
        BigDecimal bigDecimal = BigDecimal.valueOf(this.receiveAmount.getValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        String string2 = bigDecimal.movePointLeft(this.receiveAmount.getCurrency().getDecimalPlaces()).stripTrailingZeros().toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPlainString(...)");
        CharSequence charSequence = string2;
        Regex regex = new Regex("[" + QuoteAmountRequestFormatter.Companion.getDecimalSeparators() + "]");
        String string3 = String.valueOf(decimalSeparator);
        return regex.replace(charSequence, string3);
    }

    @NotNull
    public final String component1() {
        return this.quoteHistoryId;
    }

    @NotNull
    public final CountryIso3Code component2() {
        return this.destinationCountryISO3Code;
    }

    @NotNull
    public final CurrencyIso3Code component3() {
        return this.destinationCurrencyISO3Code;
    }

    @Nullable
    public final CountryBo component4() {
        return this.destinationCountry;
    }

    @NotNull
    public final CurrencyIso3Code component5() {
        return this.sourceCurrencyIso3Code;
    }

    @NotNull
    public final TransferMethod component6() {
        return this.transferMethod;
    }

    @NotNull
    public final MoneyBo component7() {
        return this.sendAmount;
    }

    @NotNull
    public final MoneyBo component8() {
        return this.receiveAmount;
    }

    @NotNull
    public final BigDecimal component9() {
        return this.rate;
    }

    @NotNull
    public final List<AdjustmentBo> component10() {
        return this.adjustments;
    }

    @NotNull
    public final MoneyBo component11() {
        return this.totalCost;
    }

    @NotNull
    public final List<String> component12() {
        return this.disclosures;
    }

    @NotNull
    public final DeliverySlaBo component13() {
        return this.deliverySLA;
    }

    @NotNull
    public final String component14() {
        return this.rsp;
    }

    @NotNull
    public final QuoteBo copy(@NotNull String quoteHistoryId, @NotNull CountryIso3Code destinationCountryISO3Code, @NotNull CurrencyIso3Code destinationCurrencyISO3Code, @Nullable CountryBo destinationCountry, @NotNull CurrencyIso3Code sourceCurrencyIso3Code, @NotNull TransferMethod transferMethod, @NotNull MoneyBo sendAmount, @NotNull MoneyBo receiveAmount, @NotNull BigDecimal rate, @NotNull List<AdjustmentBo> adjustments, @NotNull MoneyBo totalCost, @NotNull List<String> disclosures, @NotNull DeliverySlaBo deliverySLA, @NotNull String rsp) {
        Intrinsics.checkNotNullParameter((Object)quoteHistoryId, (String)"quoteHistoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)destinationCountryISO3Code), (String)"destinationCountryISO3Code");
        Intrinsics.checkNotNullParameter((Object)((Object)destinationCurrencyISO3Code), (String)"destinationCurrencyISO3Code");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceCurrencyIso3Code), (String)"sourceCurrencyIso3Code");
        Intrinsics.checkNotNullParameter((Object)transferMethod, (String)"transferMethod");
        Intrinsics.checkNotNullParameter((Object)sendAmount, (String)"sendAmount");
        Intrinsics.checkNotNullParameter((Object)receiveAmount, (String)"receiveAmount");
        Intrinsics.checkNotNullParameter((Object)rate, (String)"rate");
        Intrinsics.checkNotNullParameter(adjustments, (String)"adjustments");
        Intrinsics.checkNotNullParameter((Object)totalCost, (String)"totalCost");
        Intrinsics.checkNotNullParameter(disclosures, (String)"disclosures");
        Intrinsics.checkNotNullParameter((Object)deliverySLA, (String)"deliverySLA");
        Intrinsics.checkNotNullParameter((Object)rsp, (String)"rsp");
        return new QuoteBo(quoteHistoryId, destinationCountryISO3Code, destinationCurrencyISO3Code, destinationCountry, sourceCurrencyIso3Code, transferMethod, sendAmount, receiveAmount, rate, adjustments, totalCost, disclosures, deliverySLA, rsp);
    }

    public static /* synthetic */ QuoteBo copy$default(QuoteBo quoteBo, String string2, CountryIso3Code countryIso3Code, CurrencyIso3Code currencyIso3Code, CountryBo countryBo, CurrencyIso3Code currencyIso3Code2, TransferMethod transferMethod, MoneyBo moneyBo, MoneyBo moneyBo2, BigDecimal bigDecimal, List list, MoneyBo moneyBo3, List list2, DeliverySlaBo deliverySlaBo, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = quoteBo.quoteHistoryId;
        }
        if ((n & 2) != 0) {
            countryIso3Code = quoteBo.destinationCountryISO3Code;
        }
        if ((n & 4) != 0) {
            currencyIso3Code = quoteBo.destinationCurrencyISO3Code;
        }
        if ((n & 8) != 0) {
            countryBo = quoteBo.destinationCountry;
        }
        if ((n & 0x10) != 0) {
            currencyIso3Code2 = quoteBo.sourceCurrencyIso3Code;
        }
        if ((n & 0x20) != 0) {
            transferMethod = quoteBo.transferMethod;
        }
        if ((n & 0x40) != 0) {
            moneyBo = quoteBo.sendAmount;
        }
        if ((n & 0x80) != 0) {
            moneyBo2 = quoteBo.receiveAmount;
        }
        if ((n & 0x100) != 0) {
            bigDecimal = quoteBo.rate;
        }
        if ((n & 0x200) != 0) {
            list = quoteBo.adjustments;
        }
        if ((n & 0x400) != 0) {
            moneyBo3 = quoteBo.totalCost;
        }
        if ((n & 0x800) != 0) {
            list2 = quoteBo.disclosures;
        }
        if ((n & 0x1000) != 0) {
            deliverySlaBo = quoteBo.deliverySLA;
        }
        if ((n & 0x2000) != 0) {
            string3 = quoteBo.rsp;
        }
        return quoteBo.copy(string2, countryIso3Code, currencyIso3Code, countryBo, currencyIso3Code2, transferMethod, moneyBo, moneyBo2, bigDecimal, list, moneyBo3, list2, deliverySlaBo, string3);
    }

    @NotNull
    public String toString() {
        return "QuoteBo(quoteHistoryId=" + this.quoteHistoryId + ", destinationCountryISO3Code=" + this.destinationCountryISO3Code + ", destinationCurrencyISO3Code=" + this.destinationCurrencyISO3Code + ", destinationCountry=" + this.destinationCountry + ", sourceCurrencyIso3Code=" + this.sourceCurrencyIso3Code + ", transferMethod=" + this.transferMethod + ", sendAmount=" + this.sendAmount + ", receiveAmount=" + this.receiveAmount + ", rate=" + this.rate + ", adjustments=" + this.adjustments + ", totalCost=" + this.totalCost + ", disclosures=" + this.disclosures + ", deliverySLA=" + this.deliverySLA + ", rsp=" + this.rsp + ")";
    }

    public int hashCode() {
        int result = this.quoteHistoryId.hashCode();
        result = result * 31 + this.destinationCountryISO3Code.hashCode();
        result = result * 31 + this.destinationCurrencyISO3Code.hashCode();
        result = result * 31 + (this.destinationCountry == null ? 0 : this.destinationCountry.hashCode());
        result = result * 31 + this.sourceCurrencyIso3Code.hashCode();
        result = result * 31 + this.transferMethod.hashCode();
        result = result * 31 + this.sendAmount.hashCode();
        result = result * 31 + this.receiveAmount.hashCode();
        result = result * 31 + this.rate.hashCode();
        result = result * 31 + ((Object)this.adjustments).hashCode();
        result = result * 31 + this.totalCost.hashCode();
        result = result * 31 + ((Object)this.disclosures).hashCode();
        result = result * 31 + this.deliverySLA.hashCode();
        result = result * 31 + this.rsp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof QuoteBo)) {
            return false;
        }
        QuoteBo quoteBo = (QuoteBo)other;
        if (!Intrinsics.areEqual((Object)this.quoteHistoryId, (Object)quoteBo.quoteHistoryId)) {
            return false;
        }
        if (this.destinationCountryISO3Code != quoteBo.destinationCountryISO3Code) {
            return false;
        }
        if (this.destinationCurrencyISO3Code != quoteBo.destinationCurrencyISO3Code) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.destinationCountry, (Object)quoteBo.destinationCountry)) {
            return false;
        }
        if (this.sourceCurrencyIso3Code != quoteBo.sourceCurrencyIso3Code) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transferMethod, (Object)quoteBo.transferMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sendAmount, (Object)quoteBo.sendAmount)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.receiveAmount, (Object)quoteBo.receiveAmount)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rate, (Object)quoteBo.rate)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.adjustments, quoteBo.adjustments)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.totalCost, (Object)quoteBo.totalCost)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.disclosures, quoteBo.disclosures)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.deliverySLA, (Object)quoteBo.deliverySLA)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.rsp, (Object)quoteBo.rsp);
    }
}

