/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.domain.usecase.transfer.quote;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.exception.QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException;
import com.brightwell.readyremit.sdk.core.domain.exception.QuoteValueGreaterThanBalanceException;
import com.brightwell.readyremit.sdk.core.domain.model.QuoteBo;
import java.math.BigDecimal;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b\r\u0010\u000eR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/BalanceCheckOnQuoteUseCase;", "", "<init>", "()V", "MIN_AMOUNT_TO_TRANSFER", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "Ljava/math/BigDecimal;", "execute", "Lkotlin/Result;", "Lcom/brightwell/readyremit/sdk/core/domain/model/QuoteBo;", "quote", "balanceValue", "execute-gIAlu-s", "(Lcom/brightwell/readyremit/sdk/core/domain/model/QuoteBo;Ljava/math/BigDecimal;)Ljava/lang/Object;", "sdk_release"})
@StabilityInferred(parameters=0)
public final class BalanceCheckOnQuoteUseCase {
    private final BigDecimal MIN_AMOUNT_TO_TRANSFER = BigDecimal.TEN;
    public static final int $stable = 8;

    @Inject
    public BalanceCheckOnQuoteUseCase() {
    }

    @NotNull
    public final Object execute-gIAlu-s(@NotNull QuoteBo quote, @NotNull BigDecimal balanceValue) {
        Intrinsics.checkNotNullParameter((Object)quote, (String)"quote");
        Intrinsics.checkNotNullParameter((Object)balanceValue, (String)"balanceValue");
        if (balanceValue.compareTo(quote.getTotalCost().bigDecimal()) >= 0) {
            return Result.constructor-impl((Object)quote);
        }
        boolean sendAmountCanBeLowered = quote.getSendAmount().bigDecimal().compareTo(this.MIN_AMOUNT_TO_TRANSFER) > 0;
        return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)(sendAmountCanBeLowered ? (RuntimeException)new QuoteValueGreaterThanBalanceException(balanceValue, quote.getTotalCost()) : (RuntimeException)new QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException(quote.getSendAmount().bigDecimal(), balanceValue, quote.getTotalCost()))));
    }
}

