/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.domain.usecase.transfer.quote;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.RrError;
import com.brightwell.readyremit.sdk.core.domain.exception.BalanceIsNotEnoughForAnyQuoteException;
import com.brightwell.readyremit.sdk.core.domain.exception.QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException;
import com.brightwell.readyremit.sdk.core.domain.exception.QuoteValueGreaterThanBalanceException;
import com.brightwell.readyremit.sdk.core.domain.model.MoneyBo;
import com.brightwell.readyremit.sdk.core.domain.model.QuoteBo;
import com.brightwell.readyremit.sdk.core.domain.model.QuoteByMethodBo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/BalanceCheckWithQuotesUseCase;", "", "<init>", "()V", "MIN_AMOUNT_TO_TRANSFER", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "Ljava/math/BigDecimal;", "execute", "Lkotlin/Result;", "", "Lcom/brightwell/readyremit/sdk/core/domain/model/QuoteByMethodBo;", "sendAmount", "quotesByMethod", "balanceValue", "execute-0E7RQCE", "(Ljava/math/BigDecimal;Ljava/util/List;Ljava/math/BigDecimal;)Ljava/lang/Object;", "sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBalanceCheckWithQuotesUseCase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalanceCheckWithQuotesUseCase.kt\ncom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/BalanceCheckWithQuotesUseCase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1557#2:70\n1628#2,3:71\n*S KotlinDebug\n*F\n+ 1 BalanceCheckWithQuotesUseCase.kt\ncom/brightwell/readyremit/sdk/core/domain/usecase/transfer/quote/BalanceCheckWithQuotesUseCase\n*L\n26#1:70\n26#1:71,3\n*E\n"})
public final class BalanceCheckWithQuotesUseCase {
    private final BigDecimal MIN_AMOUNT_TO_TRANSFER = BigDecimal.TEN;
    public static final int $stable = 8;

    @Inject
    public BalanceCheckWithQuotesUseCase() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Object execute-0E7RQCE(@NotNull BigDecimal sendAmount, @NotNull List<QuoteByMethodBo> quotesByMethod, @Nullable BigDecimal balanceValue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)sendAmount, (String)"sendAmount");
        Intrinsics.checkNotNullParameter(quotesByMethod, (String)"quotesByMethod");
        if (balanceValue == null) {
            return Result.constructor-impl(quotesByMethod);
        }
        String string2 = balanceValue.setScale(2, RoundingMode.HALF_EVEN).toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPlainString(...)");
        int balance = Integer.parseInt(StringsKt.replace$default((String)string2, (String)".", (String)"", (boolean)false, (int)4, null));
        int quantityOfQuotesLowerThanBalance = 0;
        MoneyBo minimumRequiredAmount = null;
        minimumRequiredAmount = new MoneyBo(Integer.MAX_VALUE, null, 2, null);
        Iterable $this$map$iv = quotesByMethod;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            QuoteByMethodBo quoteByMethodBo;
            void quoteByMethod;
            QuoteByMethodBo quoteByMethodBo2 = (QuoteByMethodBo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (quoteByMethod.getError() == null) {
                Object object = quoteByMethod.getQuote();
                if (balance < (object != null && (object = ((QuoteBo)object).getTotalCost()) != null ? ((MoneyBo)object).getValue() : 0)) {
                    ++quantityOfQuotesLowerThanBalance;
                    Object object2 = quoteByMethod.getQuote();
                    Integer n = object2 != null && (object2 = ((QuoteBo)object2).getTotalCost()) != null ? Integer.valueOf(((MoneyBo)object2).getValue()) : null;
                    Intrinsics.checkNotNull(n);
                    if (n < minimumRequiredAmount.getValue()) {
                        minimumRequiredAmount = quoteByMethod.getQuote().getTotalCost();
                    }
                    boolean sendAmountCanBeLowered = sendAmount.compareTo(this.MIN_AMOUNT_TO_TRANSFER) > 0;
                    quoteByMethodBo = QuoteByMethodBo.copy$default((QuoteByMethodBo)quoteByMethod, null, null, null, new RrError(null, null, null, null, null, null, sendAmountCanBeLowered ? (RuntimeException)new QuoteValueGreaterThanBalanceException(balanceValue, quoteByMethod.getQuote().getTotalCost()) : (RuntimeException)new QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException(sendAmount, balanceValue, quoteByMethod.getQuote().getTotalCost()), 63, null), null, 23, null);
                } else {
                    quoteByMethodBo = quoteByMethod;
                }
            } else {
                quoteByMethodBo = quoteByMethod;
            }
            collection.add(quoteByMethodBo);
        }
        List updatedQuotesByMethod = (List)destination$iv$iv;
        if (quantityOfQuotesLowerThanBalance == quotesByMethod.size()) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new BalanceIsNotEnoughForAnyQuoteException(balanceValue, minimumRequiredAmount, updatedQuotesByMethod)));
        }
        return Result.constructor-impl((Object)updatedQuotesByMethod);
    }
}

