/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.model.ReadyRemitLanguage;
import com.brightwell.readyremit.sdk.core.ui.ILocaleConfigurator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/brightwell/readyremit/sdk/core/ui/LocaleConfigurator;", "Lcom/brightwell/readyremit/sdk/core/ui/ILocaleConfigurator;", "<init>", "()V", "getDefaultLanguage", "", "setLocaleLanguage", "", "languageCode", "Lcom/brightwell/readyremit/sdk/core/domain/model/ReadyRemitLanguage;", "sdk_release"})
@StabilityInferred(parameters=1)
public final class LocaleConfigurator
implements ILocaleConfigurator {
    @NotNull
    public static final LocaleConfigurator INSTANCE = new LocaleConfigurator();
    public static final int $stable;

    private LocaleConfigurator() {
    }

    @Override
    @NotNull
    public String getDefaultLanguage() {
        Locale defaultLocale = Locale.getDefault();
        if (Intrinsics.areEqual((Object)defaultLocale.getLanguage(), (Object)ReadyRemitLanguage.enUS.getLocale().getLanguage())) {
            return ReadyRemitLanguage.enUS.getLanguageForApi();
        }
        if (Intrinsics.areEqual((Object)defaultLocale.getLanguage(), (Object)ReadyRemitLanguage.esMX.getLocale().getLanguage())) {
            return ReadyRemitLanguage.esMX.getLanguageForApi();
        }
        String string2 = Locale.getDefault().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return StringsKt.replace$default((String)string2, (String)"_", (String)"-", (boolean)false, (int)4, null);
    }

    @Override
    public void setLocaleLanguage(@NotNull ReadyRemitLanguage languageCode) {
        Intrinsics.checkNotNullParameter((Object)((Object)languageCode), (String)"languageCode");
        Locale.setDefault(languageCode.getLocale());
    }
}

