/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.ui.model;

import com.brightwell.readyremit.sdk.ReadyRemit;
import com.brightwell.readyremit.sdk.core.domain.model.CurrencyIso3Code;
import com.brightwell.readyremit.sdk.core.domain.model.QuoteBo;
import com.brightwell.readyremit.sdk.utils.StringExtKt;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\b\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"getDisplayExchangeRate", "", "Lcom/brightwell/readyremit/sdk/core/domain/model/QuoteBo;", "showSymbol", "", "defaultLocale", "Ljava/util/Locale;", "getDisplayExchangeRateWithSymbol", "latestDeliveryDate", "dateSubmitted", "Ljava/time/LocalDate;", "sdk_release"})
public final class QuoteUiModelKt {
    @NotNull
    public static final String getDisplayExchangeRate(@NotNull QuoteBo $this$getDisplayExchangeRate, boolean showSymbol, @NotNull Locale defaultLocale) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisplayExchangeRate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)defaultLocale, (String)"defaultLocale");
        String sendAmountCurrencySymbol = showSymbol ? $this$getDisplayExchangeRate.getSendAmount().getCurrency().getSymbol() : "";
        String receiveAmountCurrencySymbol = showSymbol ? $this$getDisplayExchangeRate.getReceiveAmount().getCurrency().getSymbol() : "";
        NumberFormat it = NumberFormat.getInstance(defaultLocale);
        boolean bl = false;
        if (it instanceof DecimalFormat) {
            ((DecimalFormat)it).setDecimalFormatSymbols(new DecimalFormatSymbols(defaultLocale));
        }
        String rateWithDecimalSymbol = it.format($this$getDisplayExchangeRate.getRate());
        return sendAmountCurrencySymbol + "1 " + $this$getDisplayExchangeRate.getSourceCurrencyIso3Code() + " = " + receiveAmountCurrencySymbol + rateWithDecimalSymbol + " " + $this$getDisplayExchangeRate.getDestinationCurrencyISO3Code();
    }

    public static /* synthetic */ String getDisplayExchangeRate$default(QuoteBo quoteBo, boolean bl, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            locale = Locale.getDefault();
        }
        return QuoteUiModelKt.getDisplayExchangeRate(quoteBo, bl, locale);
    }

    @NotNull
    public static final String getDisplayExchangeRateWithSymbol(@NotNull QuoteBo $this$getDisplayExchangeRateWithSymbol, @NotNull Locale defaultLocale) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisplayExchangeRateWithSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)defaultLocale, (String)"defaultLocale");
        NumberFormat it = NumberFormat.getInstance(defaultLocale);
        boolean bl = false;
        if (it instanceof DecimalFormat) {
            ((DecimalFormat)it).setDecimalFormatSymbols(new DecimalFormatSymbols(defaultLocale));
        }
        String rateWithDecimalSymbol = it.format($this$getDisplayExchangeRateWithSymbol.getRate());
        CurrencyIso3Code currencyIso3Code = $this$getDisplayExchangeRateWithSymbol.getSourceCurrencyIso3Code();
        String string2 = StringExtKt.orNull($this$getDisplayExchangeRateWithSymbol.getReceiveAmount().getCurrency().getSymbol());
        if (string2 == null) {
            string2 = "$";
        }
        return "$1 " + currencyIso3Code + " = " + string2 + rateWithDecimalSymbol + " " + $this$getDisplayExchangeRateWithSymbol.getDestinationCurrencyISO3Code();
    }

    public static /* synthetic */ String getDisplayExchangeRateWithSymbol$default(QuoteBo quoteBo, Locale locale, int n, Object object) {
        if ((n & 1) != 0) {
            locale = Locale.getDefault();
        }
        return QuoteUiModelKt.getDisplayExchangeRateWithSymbol(quoteBo, locale);
    }

    @NotNull
    public static final String latestDeliveryDate(@NotNull QuoteBo $this$latestDeliveryDate, @NotNull LocalDate dateSubmitted) {
        Intrinsics.checkNotNullParameter((Object)$this$latestDeliveryDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dateSubmitted, (String)"dateSubmitted");
        LocalDate updatedDate = switch ($this$latestDeliveryDate.getDeliverySLA().getId()) {
            case "INSTANT" -> dateSubmitted;
            case "TEN_MINUTES" -> dateSubmitted;
            case "THIRTY_MINUTES" -> dateSubmitted;
            case "SAME_BUSINESS_DAY" -> dateSubmitted;
            case "NEXT_BUSINESS_DAY" -> dateSubmitted.plus(1L, ChronoUnit.DAYS);
            case "TWO_BUSINESS_DAYS" -> dateSubmitted.plus(2L, ChronoUnit.DAYS);
            case "FIVE_BUSINESS_DAYS" -> dateSubmitted.plus(5L, ChronoUnit.DAYS);
            case "THIRTY_MINUTES_TO_TWO_BUSINESS_DAYS" -> dateSubmitted.plus(2L, ChronoUnit.DAYS);
            default -> dateSubmitted;
        };
        String string2 = updatedDate.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return ReadyRemit.INSTANCE.formatDateFromString$sdk_release(string2, "yyyy-MM-dd");
    }

    public static /* synthetic */ String latestDeliveryDate$default(QuoteBo quoteBo, LocalDate localDate, int n, Object object) {
        if ((n & 1) != 0) {
            localDate = LocalDate.now();
        }
        return QuoteUiModelKt.latestDeliveryDate(quoteBo, localDate);
    }
}

