/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.ui.navigator;

import androidx.activity.ComponentActivity;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavController;
import androidx.navigation.NavOptionsBuilder;
import androidx.navigation.PopUpToBuilder;
import com.brightwell.readyremit.sdk.core.domain.navigator.IReadyRemitNavigator;
import com.brightwell.readyremit.sdk.core.domain.navigator.RrDestination;
import com.brightwell.readyremit.sdk.core.ui.navigator.NavigationExtKt;
import com.brightwell.readyremit.sdk.new_arch.features.transfer.review.TransferReviewScreenKt;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/brightwell/readyremit/sdk/core/ui/navigator/ReadyRemitNavigator;", "Lcom/brightwell/readyremit/sdk/core/domain/navigator/IReadyRemitNavigator;", "navController", "Landroidx/navigation/NavController;", "<init>", "(Landroidx/navigation/NavController;)V", "stack", "Ljava/util/Stack;", "Lcom/brightwell/readyremit/sdk/core/domain/navigator/RrDestination;", "getStack", "()Ljava/util/Stack;", "navigate", "", "destination", "poppingOut", "", "back", "getPreviousScreen", "sdk_release"})
@StabilityInferred(parameters=0)
public final class ReadyRemitNavigator
implements IReadyRemitNavigator {
    @NotNull
    private final NavController navController;
    @NotNull
    private final Stack<RrDestination> stack;
    public static final int $stable = 8;

    public ReadyRemitNavigator(@NotNull NavController navController) {
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        this.navController = navController;
        this.stack = new Stack();
    }

    @Override
    @NotNull
    public Stack<RrDestination> getStack() {
        return this.stack;
    }

    @Override
    public void navigate(@NotNull RrDestination destination, boolean poppingOut) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        RrDestination rrDestination = destination;
        if (Intrinsics.areEqual((Object)rrDestination, (Object)RrDestination.Home.INSTANCE)) {
            NavigationExtKt.navigateToHomeScreen(this.navController, poppingOut);
            if (poppingOut) {
                this.getStack().clear();
            }
        } else if (rrDestination instanceof RrDestination.StartTransfer) {
            NavigationExtKt.navigateToStartTransfer(this.navController, ((RrDestination.StartTransfer)destination).getWithCleanStack());
            if (((RrDestination.StartTransfer)destination).getWithCleanStack()) {
                while (this.getStack().size() > 0 && !(this.getStack().peek() instanceof RrDestination.StartTransfer)) {
                    this.getStack().pop();
                }
            }
        } else if (rrDestination instanceof RrDestination.TransfersList) {
            NavigationExtKt.navigateToTransfersList(this.navController, ((RrDestination.TransfersList)destination).getType());
        } else if (rrDestination instanceof RrDestination.AftPaymentMethods) {
            NavigationExtKt.navigateToAftPaymentMethods(this.navController, ((RrDestination.AftPaymentMethods)destination).isInPreviewMode());
        } else if (rrDestination instanceof RrDestination.TransferStatusScreen) {
            NavigationExtKt.navigateToTransferStatus(this.navController, ((RrDestination.TransferStatusScreen)destination).getTransferId(), ((RrDestination.TransferStatusScreen)destination).getWithCleanStack());
            if (((RrDestination.TransferStatusScreen)destination).getWithCleanStack()) {
                this.getStack().removeIf(arg_0 -> ReadyRemitNavigator.navigate$lambda$1(ReadyRemitNavigator::navigate$lambda$0, arg_0));
                if (!this.getStack().contains(RrDestination.Home.INSTANCE)) {
                    this.getStack().push(RrDestination.Home.INSTANCE);
                }
            }
        } else if (rrDestination instanceof RrDestination.ChooseRecipientAccount) {
            this.navController.navigate((Object)RrDestination.ChooseRecipientAccount.INSTANCE, arg_0 -> ReadyRemitNavigator.navigate$lambda$3(poppingOut, this, arg_0));
        } else if (rrDestination instanceof RrDestination.TransferAdditionalInformationScreen) {
            this.navController.navigate((Object)RrDestination.TransferAdditionalInformationScreen.INSTANCE, arg_0 -> ReadyRemitNavigator.navigate$lambda$5(poppingOut, this, arg_0));
        } else if (rrDestination instanceof RrDestination.CashDepositDetailsScreen) {
            this.navController.navigate((Object)RrDestination.CashDepositDetailsScreen.INSTANCE, arg_0 -> ReadyRemitNavigator.navigate$lambda$7(poppingOut, this, arg_0));
        } else if (rrDestination instanceof RrDestination.CashPanyScreen) {
            this.navController.navigate((Object)RrDestination.CashPanyScreen.INSTANCE, arg_0 -> ReadyRemitNavigator.navigate$lambda$9(poppingOut, this, arg_0));
        } else {
            this.navController.navigate((Object)destination, arg_0 -> ReadyRemitNavigator.navigate$lambda$11(poppingOut, this, arg_0));
        }
        this.getStack().push(destination);
    }

    @Override
    public void back() {
        boolean popped = this.navController.popBackStack();
        if (!popped || this.getStack().size() == 1) {
            this.getStack().pop();
            ComponentActivity componentActivity = TransferReviewScreenKt.getActivity(this.navController.getContext());
            if (componentActivity != null) {
                componentActivity.finish();
            }
        } else {
            this.getStack().pop();
        }
    }

    @Override
    @Nullable
    public RrDestination getPreviousScreen() {
        if (this.getStack().size() > 1) {
            RrDestination lastItem = this.getStack().pop();
            RrDestination previous = this.getStack().peek();
            this.getStack().push(lastItem);
            return previous;
        }
        return null;
    }

    private static final boolean navigate$lambda$0(RrDestination it) {
        return !Intrinsics.areEqual((Object)it, (Object)RrDestination.Home.INSTANCE);
    }

    private static final boolean navigate$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit navigate$lambda$3$lambda$2(PopUpToBuilder $this$popUpTo) {
        Intrinsics.checkNotNullParameter((Object)$this$popUpTo, (String)"$this$popUpTo");
        $this$popUpTo.setInclusive(true);
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$3(boolean $poppingOut, ReadyRemitNavigator this$0, NavOptionsBuilder $this$navigate) {
        Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
        if ($poppingOut) {
            String string2;
            NavBackStackEntry navBackStackEntry = this$0.navController.getCurrentBackStackEntry();
            if ((navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getDestination()) != null ? navBackStackEntry.getRoute() : (string2 = null)) == null) {
                string2 = "";
            }
            $this$navigate.popUpTo(string2, ReadyRemitNavigator::navigate$lambda$3$lambda$2);
            this$0.getStack().pop();
        }
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$5$lambda$4(PopUpToBuilder $this$popUpTo) {
        Intrinsics.checkNotNullParameter((Object)$this$popUpTo, (String)"$this$popUpTo");
        $this$popUpTo.setInclusive(true);
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$5(boolean $poppingOut, ReadyRemitNavigator this$0, NavOptionsBuilder $this$navigate) {
        Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
        if ($poppingOut) {
            String string2;
            NavBackStackEntry navBackStackEntry = this$0.navController.getCurrentBackStackEntry();
            if ((navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getDestination()) != null ? navBackStackEntry.getRoute() : (string2 = null)) == null) {
                string2 = "";
            }
            $this$navigate.popUpTo(string2, ReadyRemitNavigator::navigate$lambda$5$lambda$4);
            this$0.getStack().pop();
        }
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$7$lambda$6(PopUpToBuilder $this$popUpTo) {
        Intrinsics.checkNotNullParameter((Object)$this$popUpTo, (String)"$this$popUpTo");
        $this$popUpTo.setInclusive(true);
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$7(boolean $poppingOut, ReadyRemitNavigator this$0, NavOptionsBuilder $this$navigate) {
        Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
        if ($poppingOut) {
            String string2;
            NavBackStackEntry navBackStackEntry = this$0.navController.getCurrentBackStackEntry();
            if ((navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getDestination()) != null ? navBackStackEntry.getRoute() : (string2 = null)) == null) {
                string2 = "";
            }
            $this$navigate.popUpTo(string2, ReadyRemitNavigator::navigate$lambda$7$lambda$6);
            this$0.getStack().pop();
        }
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$9$lambda$8(PopUpToBuilder $this$popUpTo) {
        Intrinsics.checkNotNullParameter((Object)$this$popUpTo, (String)"$this$popUpTo");
        $this$popUpTo.setInclusive(true);
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$9(boolean $poppingOut, ReadyRemitNavigator this$0, NavOptionsBuilder $this$navigate) {
        Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
        if ($poppingOut) {
            String string2;
            NavBackStackEntry navBackStackEntry = this$0.navController.getCurrentBackStackEntry();
            if ((navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getDestination()) != null ? navBackStackEntry.getRoute() : (string2 = null)) == null) {
                string2 = "";
            }
            $this$navigate.popUpTo(string2, ReadyRemitNavigator::navigate$lambda$9$lambda$8);
            this$0.getStack().pop();
        }
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$11$lambda$10(PopUpToBuilder $this$popUpTo) {
        Intrinsics.checkNotNullParameter((Object)$this$popUpTo, (String)"$this$popUpTo");
        $this$popUpTo.setInclusive(true);
        return Unit.INSTANCE;
    }

    private static final Unit navigate$lambda$11(boolean $poppingOut, ReadyRemitNavigator this$0, NavOptionsBuilder $this$navigate) {
        Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
        if ($poppingOut && this$0.getStack().size() > 1) {
            String string2;
            NavBackStackEntry navBackStackEntry = this$0.navController.getCurrentBackStackEntry();
            if ((navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getDestination()) != null ? navBackStackEntry.getRoute() : (string2 = null)) == null) {
                string2 = "";
            }
            $this$navigate.popUpTo(string2, ReadyRemitNavigator::navigate$lambda$11$lambda$10);
            this$0.getStack().pop();
        }
        return Unit.INSTANCE;
    }
}

