/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.api.data;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.internal.api.data.Currency;
import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonClass(generateAdapter=true)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0010J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c7\u0001J\u0013\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d7\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/brightwell/readyremit/sdk/internal/api/data/Money;", "", "value", "", "currency", "Lcom/brightwell/readyremit/sdk/internal/api/data/Currency;", "<init>", "(ILcom/brightwell/readyremit/sdk/internal/api/data/Currency;)V", "getValue", "()I", "getCurrency", "()Lcom/brightwell/readyremit/sdk/internal/api/data/Currency;", "toString", "", "getDisplayValue", "showCurrency", "", "showSymbol", "component1", "component2", "copy", "equals", "other", "hashCode", "sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMoney.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Money.kt\ncom/brightwell/readyremit/sdk/internal/api/data/Money\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,30:1\n1#2:31\n*E\n"})
public final class Money {
    private final int value;
    @NotNull
    private final Currency currency;
    public static final int $stable = 8;

    public Money(int value, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        this.value = value;
        this.currency = currency;
    }

    public /* synthetic */ Money(int n, Currency currency, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            currency = new Currency(null, null, null, 0, null, null, null, 127, null);
        }
        this(n, currency);
    }

    public final int getValue() {
        return this.value;
    }

    @NotNull
    public final Currency getCurrency() {
        return this.currency;
    }

    @NotNull
    public String toString() {
        return Money.getDisplayValue$default(this, false, false, 3, null) + " " + this.currency.getName();
    }

    @NotNull
    public final String getDisplayValue(boolean showCurrency, boolean showSymbol) {
        Currency currency = this.currency;
        String iso3Code = currency.component2();
        String symbol = currency.component3();
        int decimalPlaces = currency.component4();
        BigDecimal bigDecimal = BigDecimal.valueOf(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        Object it = bigDecimal.movePointLeft(decimalPlaces);
        boolean bl = false;
        Object[] objectArray = new Object[]{it};
        it = String.format("%." + decimalPlaces + "f", objectArray);
        boolean bl2 = false;
        it = showSymbol ? symbol + (String)it : it;
        boolean bl3 = false;
        Object object = showCurrency ? (String)it + " " + iso3Code : it;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"let(...)");
        return object;
    }

    public static /* synthetic */ String getDisplayValue$default(Money money, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return money.getDisplayValue(bl, bl2);
    }

    public final int component1() {
        return this.value;
    }

    @NotNull
    public final Currency component2() {
        return this.currency;
    }

    @NotNull
    public final Money copy(int value, @NotNull Currency currency) {
        Intrinsics.checkNotNullParameter((Object)currency, (String)"currency");
        return new Money(value, currency);
    }

    public static /* synthetic */ Money copy$default(Money money, int n, Currency currency, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = money.value;
        }
        if ((n2 & 2) != 0) {
            currency = money.currency;
        }
        return money.copy(n, currency);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.value);
        result = result * 31 + this.currency.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Money)) {
            return false;
        }
        Money money = (Money)other;
        if (this.value != money.value) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.currency, (Object)money.currency);
    }

    public Money() {
        this(0, null, 3, null);
    }
}

