/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.di.module;

import android.app.Application;
import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.data.api.ReadyRemitApi;
import com.brightwell.readyremit.sdk.core.data.dto.field.InputFieldDto;
import com.brightwell.readyremit.sdk.core.data.dto.field.OutputFieldDto;
import com.brightwell.readyremit.sdk.core.domain.IAnalyticsProvider;
import com.brightwell.readyremit.sdk.core.domain.INetworkObserver;
import com.brightwell.readyremit.sdk.core.ui.AndroidNetworkObserver;
import com.brightwell.readyremit.sdk.core.ui.ILocaleConfigurator;
import com.brightwell.readyremit.sdk.core.ui.LocaleConfigurator;
import com.brightwell.readyremit.sdk.environment.Environment;
import com.brightwell.readyremit.sdk.environment.EnvironmentKt;
import com.brightwell.readyremit.sdk.internal.api.TransferApi;
import com.brightwell.readyremit.sdk.internal.api.data.InputField;
import com.brightwell.readyremit.sdk.internal.api.data.OutputField;
import com.brightwell.readyremit.sdk.internal.api.internals.ApiCallAdapterFactory;
import com.brightwell.readyremit.sdk.internal.api.internals.AuthInterceptor;
import com.brightwell.readyremit.sdk.internal.api.internals.RequestInterceptor;
import com.brightwell.readyremit.sdk.utils.IDispatcherProvider;
import com.brightwell.readyremit.sdk.utils.MixpanelManager;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.PolymorphicJsonAdapterFactory;
import dagger.Module;
import dagger.Provides;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Module
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\nJ\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0015H\u0007J\b\u0010\u0019\u001a\u00020\u0013H\u0007J\b\u0010\u001a\u001a\u00020\u0017H\u0007J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001cH\u0007J\"\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00112\b\b\u0001\u0010!\u001a\u00020\u001cH\u0007J\u0017\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b%J\"\u0010&\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00112\b\b\u0001\u0010!\u001a\u00020\u001cH\u0007J\u0017\u0010'\u001a\u00020(2\b\b\u0001\u0010$\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020+H\u0001\u00a2\u0006\u0002\b,\u00a8\u0006-"}, d2={"Lcom/brightwell/readyremit/sdk/internal/di/module/SDKModule;", "", "<init>", "()V", "providerNetworkObserver", "Lcom/brightwell/readyremit/sdk/core/domain/INetworkObserver;", "application", "Landroid/app/Application;", "iDispatcherProvider", "Lcom/brightwell/readyremit/sdk/utils/IDispatcherProvider;", "providerNetworkObserver$sdk_release", "provideAnalyticsProvider", "Lcom/brightwell/readyremit/sdk/core/domain/IAnalyticsProvider;", "environment", "Lcom/brightwell/readyremit/sdk/environment/Environment;", "provideAnalyticsProvider$sdk_release", "provideOkHttpClient", "Lokhttp3/OkHttpClient;", "authInterceptor", "Lcom/brightwell/readyremit/sdk/internal/api/internals/AuthInterceptor;", "requestInterceptor", "Lcom/brightwell/readyremit/sdk/internal/api/internals/RequestInterceptor;", "httpLoggingInterceptor", "Lokhttp3/logging/HttpLoggingInterceptor;", "provideRequestInterceptor", "provideAuthInterceptor", "provideHttpInterceptor", "providesMoshi", "Lcom/squareup/moshi/Moshi;", "providesNewMoshi", "provideRetrofit", "Lretrofit2/Retrofit;", "okHttpClient", "moshi", "provideTransferApi", "Lcom/brightwell/readyremit/sdk/internal/api/TransferApi;", "retrofit", "provideTransferApi$sdk_release", "provideNewRetrofit", "provideRrTransferApi", "Lcom/brightwell/readyremit/sdk/core/data/api/ReadyRemitApi;", "provideRrTransferApi$sdk_release", "provideLocaleConfigurator", "Lcom/brightwell/readyremit/sdk/core/ui/ILocaleConfigurator;", "provideLocaleConfigurator$sdk_release", "sdk_release"})
@StabilityInferred(parameters=1)
public final class SDKModule {
    public static final int $stable;

    @Provides
    @Singleton
    @NotNull
    public final INetworkObserver providerNetworkObserver$sdk_release(@NotNull Application application, @NotNull IDispatcherProvider iDispatcherProvider) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)iDispatcherProvider, (String)"iDispatcherProvider");
        return new AndroidNetworkObserver((Context)application, iDispatcherProvider);
    }

    @Provides
    @Singleton
    @NotNull
    public final IAnalyticsProvider provideAnalyticsProvider$sdk_release(@NotNull Application application, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        return new MixpanelManager((Context)application, environment);
    }

    @Provides
    @Singleton
    @NotNull
    public final OkHttpClient provideOkHttpClient(@NotNull AuthInterceptor authInterceptor, @NotNull RequestInterceptor requestInterceptor, @NotNull HttpLoggingInterceptor httpLoggingInterceptor) {
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        Intrinsics.checkNotNullParameter((Object)requestInterceptor, (String)"requestInterceptor");
        Intrinsics.checkNotNullParameter((Object)httpLoggingInterceptor, (String)"httpLoggingInterceptor");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)requestInterceptor).addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)authInterceptor);
        return builder.build();
    }

    @Provides
    @Singleton
    @NotNull
    public final RequestInterceptor provideRequestInterceptor() {
        return new RequestInterceptor();
    }

    @Provides
    @Singleton
    @NotNull
    public final AuthInterceptor provideAuthInterceptor() {
        return new AuthInterceptor();
    }

    @Provides
    @Singleton
    @NotNull
    public final HttpLoggingInterceptor provideHttpInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(null, 1, null);
        interceptor.level(HttpLoggingInterceptor.Level.NONE);
        return interceptor;
    }

    @Provides
    @Singleton
    @Named(value="OldMoshi")
    @NotNull
    public final Moshi providesMoshi() {
        PolymorphicJsonAdapterFactory fieldFactory = PolymorphicJsonAdapterFactory.of(OutputField.class, (String)"type").withSubtype(OutputField.Text.class, "TEXT").withSubtype(OutputField.Dropdown.class, "DROPDOWN").withSubtype(OutputField.Phone.class, "PHONE_NUMBER").withDefaultValue((Object)new OutputField.Unhandled());
        PolymorphicJsonAdapterFactory inputFieldFactory = PolymorphicJsonAdapterFactory.of(InputField.class, (String)"fieldType").withSubtype(InputField.Text.class, "TEXT").withSubtype(InputField.Dropdown.class, "DROPDOWN").withSubtype(InputField.Phone.class, "PHONE_NUMBER").withDefaultValue((Object)new InputField.Unhandled());
        Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)fieldFactory).add((JsonAdapter.Factory)inputFieldFactory).build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
        return moshi;
    }

    @Provides
    @Named(value="NewMoshi")
    @NotNull
    public final Moshi providesNewMoshi() {
        PolymorphicJsonAdapterFactory outputFieldFactory = PolymorphicJsonAdapterFactory.of(OutputFieldDto.class, (String)"type").withSubtype(OutputFieldDto.Text.class, "TEXT").withSubtype(OutputFieldDto.Dropdown.class, "DROPDOWN").withSubtype(OutputFieldDto.Phone.class, "PHONE_NUMBER").withDefaultValue((Object)new OutputFieldDto.Unknown(null, null, null, null, 15, null));
        PolymorphicJsonAdapterFactory newInputFieldFactory = PolymorphicJsonAdapterFactory.of(InputFieldDto.class, (String)"fieldType").withSubtype(InputFieldDto.Text.class, "TEXT").withSubtype(InputFieldDto.Dropdown.class, "DROPDOWN").withSubtype(InputFieldDto.Phone.class, "PHONE_NUMBER").withDefaultValue((Object)new InputFieldDto.Unknown(null, null, null, false, null, null, null, false, 0, 511, null));
        Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)outputFieldFactory).add((JsonAdapter.Factory)newInputFieldFactory).build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
        return moshi;
    }

    @Provides
    @Named(value="OldRetrofit")
    @NotNull
    public final Retrofit provideRetrofit(@NotNull Environment environment, @NotNull OkHttpClient okHttpClient, @Named(value="OldMoshi") @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(EnvironmentKt.getTransferApiBaseUrl(environment)).addCallAdapterFactory((CallAdapter.Factory)new ApiCallAdapterFactory()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moshi)).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        return retrofit;
    }

    @Provides
    @NotNull
    public final TransferApi provideTransferApi$sdk_release(@Named(value="OldRetrofit") @NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(TransferApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (TransferApi)object;
    }

    @Provides
    @Named(value="NewRetrofit")
    @NotNull
    public final Retrofit provideNewRetrofit(@NotNull Environment environment, @NotNull OkHttpClient okHttpClient, @Named(value="NewMoshi") @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(EnvironmentKt.getTransferApiBaseUrl(environment)).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moshi)).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        return retrofit;
    }

    @Provides
    @NotNull
    public final ReadyRemitApi provideRrTransferApi$sdk_release(@Named(value="NewRetrofit") @NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(ReadyRemitApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (ReadyRemitApi)object;
    }

    @Provides
    @Singleton
    @NotNull
    public final ILocaleConfigurator provideLocaleConfigurator$sdk_release() {
        return LocaleConfigurator.INSTANCE;
    }
}

