/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.new_arch.features.transfer.start;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.core.data.ReadyRemitErrorMapperImpl;
import com.brightwell.readyremit.sdk.core.domain.ErrorType;
import com.brightwell.readyremit.sdk.core.domain.RrError;
import com.brightwell.readyremit.sdk.core.domain.UiString;
import com.brightwell.readyremit.sdk.core.domain.exception.BalanceIsNotEnoughForAnyQuoteException;
import com.brightwell.readyremit.sdk.core.domain.exception.QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException;
import com.brightwell.readyremit.sdk.core.domain.exception.QuoteValueGreaterThanBalanceException;
import com.brightwell.readyremit.sdk.core.domain.model.MoneyBo;
import com.brightwell.readyremit.sdk.core.domain.model.QuoteBoKt;
import com.brightwell.readyremit.sdk.internal.api.ApiError;
import java.math.BigDecimal;
import java.net.SocketTimeoutException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Response;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B5\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/brightwell/readyremit/sdk/new_arch/features/transfer/start/StartTransferErrorMapper;", "Lcom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl;", "httpErrorMapper", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "", "Lcom/brightwell/readyremit/sdk/internal/api/ApiError;", "singleHttpErrorMapper", "<init>", "(Lretrofit2/Converter;Lretrofit2/Converter;)V", "map", "Lcom/brightwell/readyremit/sdk/core/domain/RrError;", "error", "", "generateUiTitle", "Lcom/brightwell/readyremit/sdk/core/domain/UiString;", "apiErrorDto", "Lcom/brightwell/readyremit/sdk/core/data/ReadyRemitErrorMapperImpl$ApiErrorDto;", "generateUiMessage", "sdk_release"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nStartTransferErrorMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartTransferErrorMapper.kt\ncom/brightwell/readyremit/sdk/new_arch/features/transfer/start/StartTransferErrorMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class StartTransferErrorMapper
extends ReadyRemitErrorMapperImpl {
    public static final int $stable;

    public StartTransferErrorMapper(@NotNull Converter<ResponseBody, List<ApiError>> httpErrorMapper, @NotNull Converter<ResponseBody, ApiError> singleHttpErrorMapper) {
        Intrinsics.checkNotNullParameter(httpErrorMapper, (String)"httpErrorMapper");
        Intrinsics.checkNotNullParameter(singleHttpErrorMapper, (String)"singleHttpErrorMapper");
        super(httpErrorMapper, singleHttpErrorMapper);
    }

    @Override
    @NotNull
    public RrError map(@NotNull Throwable error) {
        RrError rrError;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (throwable instanceof QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException) {
            UiString uiString = new UiString(R.string.rrm_insufficient_funds, "Insufficient funds", null, null, false, 28, null);
            UiString uiString2 = new UiString(R.string.rrm_insufficient_funds_quote_error, null, CollectionsKt.listOf((Object)MoneyBo.getDisplayValue$default(((QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException)error).getRequiredAmount(), false, false, 2, null)), null, false, 26, null);
            ErrorType.BUSINESS bUSINESS = ErrorType.BUSINESS.INSTANCE;
            QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException quoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException = (QuoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException)error;
            rrError = new RrError(null, null, uiString, uiString2, null, bUSINESS, quoteValueGreaterThanBalanceButSendAmountCannotBeLoweredException, 2, null);
        } else if (throwable instanceof QuoteValueGreaterThanBalanceException) {
            UiString uiString = new UiString(R.string.rrm_insufficient_funds, "Insufficient funds", null, null, false, 28, null);
            UiString uiString3 = new UiString(R.string.rrm_insufficient_funds_quote_error, null, CollectionsKt.listOf((Object)MoneyBo.getDisplayValue$default(((QuoteValueGreaterThanBalanceException)error).getRequiredAmount(), false, false, 2, null)), null, false, 26, null);
            ErrorType.BUSINESS bUSINESS = ErrorType.BUSINESS.INSTANCE;
            QuoteValueGreaterThanBalanceException quoteValueGreaterThanBalanceException = (QuoteValueGreaterThanBalanceException)error;
            rrError = new RrError(null, null, uiString, uiString3, null, bUSINESS, quoteValueGreaterThanBalanceException, 2, null);
        } else if (throwable instanceof BalanceIsNotEnoughForAnyQuoteException) {
            UiString uiString = new UiString(R.string.rrm_insufficient_funds, "Insufficient funds", null, null, false, 28, null);
            Object object = new String[]{QuoteBoKt.getCurrencyDisplayValue$default(((BalanceIsNotEnoughForAnyQuoteException)error).getCurrentBalance(), null, false, false, 7, null), MoneyBo.getDisplayValue$default(((BalanceIsNotEnoughForAnyQuoteException)error).getRequiredAmount(), true, false, 2, null)};
            UiString uiString4 = new UiString(R.string.rrm_insufficient_funds_can_lower, null, CollectionsKt.listOf((Object[])object), null, false, 26, null);
            object = ErrorType.BUSINESS.INSTANCE;
            BalanceIsNotEnoughForAnyQuoteException balanceIsNotEnoughForAnyQuoteException = (BalanceIsNotEnoughForAnyQuoteException)error;
            rrError = new RrError(null, null, uiString, uiString4, null, (ErrorType)object, balanceIsNotEnoughForAnyQuoteException, 2, null);
        } else if (throwable instanceof HttpException) {
            String string2;
            ReadyRemitErrorMapperImpl.ApiErrorDto apiErrorDto = this.mapHttpErrorMessage$sdk_release((HttpException)error);
            String string3 = String.valueOf(((HttpException)error).code());
            UiString uiString = this.generateUiTitle(apiErrorDto);
            UiString uiString5 = this.generateUiMessage(apiErrorDto);
            String string4 = apiErrorDto.getMessage();
            Response response = ((HttpException)error).response();
            if (response != null && (response = response.headers()) != null) {
                Response it = response;
                boolean bl = false;
                string2 = this.getHttpResponseRequestId$sdk_release((Headers)it);
            } else {
                string2 = null;
            }
            String string5 = string2;
            HttpException httpException = (HttpException)error;
            ErrorType.API aPI = new ErrorType.API(apiErrorDto.getCode());
            rrError = new RrError(string3, string4, uiString, uiString5, string5, aPI, (Throwable)httpException);
        } else if (throwable instanceof SocketTimeoutException) {
            String string6 = error.getMessage();
            UiString uiString = new UiString(R.string.rrm_timeout, null, null, null, false, 30, null);
            ErrorType.NETWORK nETWORK = ErrorType.NETWORK.INSTANCE;
            SocketTimeoutException socketTimeoutException = (SocketTimeoutException)error;
            rrError = new RrError(null, string6, null, uiString, null, nETWORK, socketTimeoutException, 4, null);
        } else {
            rrError = super.map(error);
        }
        return rrError;
    }

    private final UiString generateUiTitle(ReadyRemitErrorMapperImpl.ApiErrorDto apiErrorDto) {
        String string2 = apiErrorDto.getCode();
        if (Intrinsics.areEqual((Object)string2, (Object)"MinLimitOutOfRangeFormat")) {
            BigDecimal bigDecimal;
            String string3;
            ReadyRemitErrorMapperImpl.ApiErrorDto.ApiErrorDetailsDto apiErrorDetailsDto = apiErrorDto.getDetails();
            String string4 = apiErrorDetailsDto != null && (string3 = apiErrorDetailsDto.getMinLimit()) != null && (bigDecimal = new BigDecimal(string3).movePointLeft(2)) != null ? QuoteBoKt.getCurrencyDisplayValue$default(bigDecimal, null, false, false, 5, null) : null;
            if (string4 == null) {
                string4 = "";
            }
            return new UiString(R.string.rrm_min_value_reached, null, CollectionsKt.listOf(string4), null, false, 26, null);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"MaxLimitOutOfRange")) {
            return new UiString(R.string.rrm_max_value_reached, "Maximum limit reached", null, null, false, 28, null);
        }
        return null;
    }

    private final UiString generateUiMessage(ReadyRemitErrorMapperImpl.ApiErrorDto apiErrorDto) {
        String string2 = apiErrorDto.getCode();
        if (Intrinsics.areEqual((Object)string2, (Object)"MinLimitOutOfRangeFormat")) {
            String string3;
            BigDecimal bigDecimal;
            String string4;
            int n = R.string.rrm_min_value_description;
            Object object = new String[2];
            Object object2 = apiErrorDto.getDetails();
            String string5 = object2 != null && (string4 = ((ReadyRemitErrorMapperImpl.ApiErrorDto.ApiErrorDetailsDto)object2).getMinLimit()) != null && (bigDecimal = new BigDecimal(string4).movePointLeft(2)) != null ? QuoteBoKt.getCurrencyDisplayValue$default(bigDecimal, null, false, false, 5, null) : null;
            if (string5 == null) {
                string5 = object[0] = "";
            }
            if ((string3 = apiErrorDto.getTrackableMessage()) == null) {
                string3 = "";
            }
            object[1] = string3;
            List list = CollectionsKt.listOf((Object[])object);
            object2 = apiErrorDto.getDetails();
            object = "Increase \"Send Amount\" to " + (object2 != null && (string4 = ((ReadyRemitErrorMapperImpl.ApiErrorDto.ApiErrorDetailsDto)object2).getMinLimit()) != null && (bigDecimal = new BigDecimal(string4).movePointLeft(2)) != null ? QuoteBoKt.getCurrencyDisplayValue$default(bigDecimal, null, false, false, 7, null) : null) + " or more";
            object2 = new UiString(R.string.rrm_to_unlock_this_method, " to unlock this method", null, new UiString(0, ".", null, new UiString(0, "\n\n" + apiErrorDto.getTrackableMessage(), null, null, false, 29, null), false, 21, null), false, 20, null);
            return new UiString(n, (String)object, list, (UiString)object2, true);
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"MaxLimitOutOfRange")) {
            int n = R.string.rrm_max_value_description;
            UiString uiString = new UiString(R.string.rrm_to_unlock_this_method, " to unlock this method", null, new UiString(0, ".", null, new UiString(0, "\n\n" + apiErrorDto.getTrackableMessage(), null, null, false, 29, null), false, 21, null), false, 20, null);
            return new UiString(n, "Decrease \"Send Amount\"", null, uiString, true, 4, null);
        }
        String string6 = apiErrorDto.getMessage();
        if (string6 == null) {
            string6 = "";
        }
        return new UiString(0, string6, null, null, false, 28, null);
    }
}

