/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.core.domain.IAnalyticsProvider;
import com.brightwell.readyremit.sdk.environment.Environment;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UninitializedPropertyAccessException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J$\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/brightwell/readyremit/sdk/utils/MixpanelManager;", "Lcom/brightwell/readyremit/sdk/core/domain/IAnalyticsProvider;", "context", "Landroid/content/Context;", "environment", "Lcom/brightwell/readyremit/sdk/environment/Environment;", "<init>", "(Landroid/content/Context;Lcom/brightwell/readyremit/sdk/environment/Environment;)V", "mixpanel", "Lcom/mixpanel/android/mpmetrics/MixpanelAPI;", "initialize", "", "senderId", "", "clientId", "trackEvent", "eventName", "properties", "", "", "createEventProperties", "Lorg/json/JSONObject;", "flushEvents", "Companion", "sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nMixpanelManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MixpanelManager.kt\ncom/brightwell/readyremit/sdk/utils/MixpanelManager\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n216#2,2:96\n*S KotlinDebug\n*F\n+ 1 MixpanelManager.kt\ncom/brightwell/readyremit/sdk/utils/MixpanelManager\n*L\n71#1:96,2\n*E\n"})
public final class MixpanelManager
implements IAnalyticsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Environment environment;
    private MixpanelAPI mixpanel;
    public static final int $stable = 8;
    @NotNull
    private static final String MIXPANEL_TOKEN = "8d2062e508a53cd5b1e9acdd48c05f07";
    @NotNull
    private static final String DEV_MIXPANEL_TOKEN = "afa2311027f8da6b4505a1cea4d0b5db";
    @NotNull
    private static final String SANDBOX_MIXPANEL_TOKEN = "fb700583c6e811d2ad38ae8aa324e965";

    @Inject
    public MixpanelManager(@NotNull Context context, @NotNull Environment environment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this.context = context;
        this.environment = environment;
    }

    @Override
    public void initialize(@NotNull String senderId, @NotNull String clientId) {
        Intrinsics.checkNotNullParameter((Object)senderId, (String)"senderId");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        String envToken = this.environment == Environment.DEVELOPMENT ? DEV_MIXPANEL_TOKEN : (this.environment == Environment.SANDBOX ? SANDBOX_MIXPANEL_TOKEN : MIXPANEL_TOKEN);
        this.mixpanel = MixpanelAPI.getInstance((Context)this.context, (String)envToken, (boolean)true);
        Map props = new LinkedHashMap();
        props.put("client_id", clientId);
        props.put("sender_id", senderId);
        MixpanelAPI mixpanelAPI = this.mixpanel;
        if (mixpanelAPI == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mixpanel");
            mixpanelAPI = null;
        }
        mixpanelAPI.identify(senderId);
        MixpanelAPI mixpanelAPI2 = this.mixpanel;
        if (mixpanelAPI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mixpanel");
            mixpanelAPI2 = null;
        }
        mixpanelAPI2.getPeople().setOnceMap(props);
        MixpanelAPI mixpanelAPI3 = this.mixpanel;
        if (mixpanelAPI3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mixpanel");
            mixpanelAPI3 = null;
        }
        mixpanelAPI3.registerSuperProperties(this.createEventProperties(props));
    }

    @Override
    public void trackEvent(@NotNull String eventName, @NotNull Map<String, ? extends Object> properties) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Map props = MapsKt.toMutableMap(properties);
        try {
            JSONObject mixpanelProps = this.createEventProperties(props);
            MixpanelAPI mixpanelAPI = this.mixpanel;
            if (mixpanelAPI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mixpanel");
                mixpanelAPI = null;
            }
            mixpanelAPI.track(eventName, mixpanelProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final JSONObject createEventProperties(Map<String, ? extends Object> properties) {
        JSONObject jSONObject;
        Map props = null;
        props = properties;
        JSONObject $this$createEventProperties_u24lambda_u241 = jSONObject = new JSONObject();
        boolean bl = false;
        if (!props.containsKey("success")) {
            props = MapsKt.plus(props, (Pair)TuplesKt.to((Object)"success", (Object)true));
        }
        Map $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            JSONObject jSONObject2 = value instanceof Map ? $this$createEventProperties_u24lambda_u241.put(key, (Object)this.createEventProperties((Map)value)) : $this$createEventProperties_u24lambda_u241.put(key, value);
        }
        return jSONObject;
    }

    @Override
    public void flushEvents() {
        try {
            MixpanelAPI mixpanelAPI = this.mixpanel;
            if (mixpanelAPI == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mixpanel");
                mixpanelAPI = null;
            }
            mixpanelAPI.flush();
            MixpanelAPI mixpanelAPI2 = this.mixpanel;
            MixpanelAPI mixpanelAPI3 = mixpanelAPI2;
            if (mixpanelAPI3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mixpanel");
                mixpanelAPI3 = null;
            }
            mixpanelAPI3.reset();
        }
        catch (UninitializedPropertyAccessException uninitializedPropertyAccessException) {
            // empty catch block
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/brightwell/readyremit/sdk/utils/MixpanelManager$Companion;", "", "<init>", "()V", "MIXPANEL_TOKEN", "", "DEV_MIXPANEL_TOKEN", "SANDBOX_MIXPANEL_TOKEN", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

