/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils.secure;

import android.util.Base64;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002J$\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/brightwell/readyremit/sdk/utils/secure/JWTDecoder;", "", "<init>", "()V", "decode", "T", "jwt", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "convertBase64", "base64", "dismember", "Lkotlin/Triple;", "sdk_release"})
@StabilityInferred(parameters=1)
public final class JWTDecoder {
    @NotNull
    public static final JWTDecoder INSTANCE = new JWTDecoder();
    public static final int $stable;

    private JWTDecoder() {
    }

    @Nullable
    public final <T> T decode(@NotNull String jwt, @NotNull Class<T> clazz) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Triple<String, String, String> triple = this.dismember(jwt);
        if (triple == null) {
            return null;
        }
        String payload = (String)triple.component2();
        String string2 = this.convertBase64(payload);
        if (string2 == null) {
            return null;
        }
        String payloadData = string2;
        try {
            object = new Gson().fromJson(payloadData, clazz);
        }
        catch (JsonSyntaxException e) {
            object = null;
        }
        return (T)object;
    }

    private final String convertBase64(String base64) {
        String string2;
        try {
            byte[] decodedBytes = Base64.decode((String)base64, (int)8);
            Intrinsics.checkNotNull((Object)decodedBytes);
            byte[] byArray = decodedBytes;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            string2 = new String(byArray, charset2);
        }
        catch (IllegalArgumentException e) {
            string2 = null;
        }
        return string2;
    }

    private final Triple<String, String, String> dismember(String jwt) {
        String[] stringArray = new String[]{"."};
        List segments = StringsKt.split$default((CharSequence)jwt, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return segments.size() == 3 ? new Triple(segments.get(0), segments.get(1), segments.get(2)) : null;
    }
}

