/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.utils.secure.JWTDecoder;
import com.google.gson.annotations.SerializedName;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c7\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d7\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d7\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d7\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/brightwell/readyremit/sdk/utils/secure/ReadyRemitJWT;", "", "clientId", "", "senderId", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getClientId", "()Ljava/lang/String;", "setClientId", "(Ljava/lang/String;)V", "getSenderId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "sdk_release"})
@StabilityInferred(parameters=0)
public final class ReadyRemitJWT {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="sub")
    @NotNull
    private String clientId;
    @SerializedName(value="https://api.readyremit.com/sender_id")
    @NotNull
    private final String senderId;
    public static final int $stable = 8;

    public ReadyRemitJWT(@NotNull String clientId, @NotNull String senderId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)senderId, (String)"senderId");
        this.clientId = clientId;
        this.senderId = senderId;
    }

    @NotNull
    public final String getClientId() {
        return this.clientId;
    }

    public final void setClientId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.clientId = string2;
    }

    @NotNull
    public final String getSenderId() {
        return this.senderId;
    }

    @NotNull
    public final String component1() {
        return this.clientId;
    }

    @NotNull
    public final String component2() {
        return this.senderId;
    }

    @NotNull
    public final ReadyRemitJWT copy(@NotNull String clientId, @NotNull String senderId) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)senderId, (String)"senderId");
        return new ReadyRemitJWT(clientId, senderId);
    }

    public static /* synthetic */ ReadyRemitJWT copy$default(ReadyRemitJWT readyRemitJWT, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = readyRemitJWT.clientId;
        }
        if ((n & 2) != 0) {
            string3 = readyRemitJWT.senderId;
        }
        return readyRemitJWT.copy(string2, string3);
    }

    @NotNull
    public String toString() {
        return "ReadyRemitJWT(clientId=" + this.clientId + ", senderId=" + this.senderId + ")";
    }

    public int hashCode() {
        int result = this.clientId.hashCode();
        result = result * 31 + this.senderId.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ReadyRemitJWT)) {
            return false;
        }
        ReadyRemitJWT readyRemitJWT = (ReadyRemitJWT)other;
        if (!Intrinsics.areEqual((Object)this.clientId, (Object)readyRemitJWT.clientId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.senderId, (Object)readyRemitJWT.senderId);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/brightwell/readyremit/sdk/utils/secure/ReadyRemitJWT$Companion;", "", "<init>", "()V", "from", "Lcom/brightwell/readyremit/sdk/utils/secure/ReadyRemitJWT;", "jwt", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReadyRemitJWT from(@NotNull String jwt) {
            Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
            ReadyRemitJWT readyRemitJWT = JWTDecoder.INSTANCE.decode(jwt, ReadyRemitJWT.class);
            if (readyRemitJWT == null) {
                readyRemitJWT = new ReadyRemitJWT("", "");
            }
            return readyRemitJWT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

