/*
 * Decompiled with CFR 0.152.
 */
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.LiveData;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\rH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u0016H\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"LNetworkStatusHelper;", "Landroidx/lifecycle/LiveData;", "LNetworkStatus;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "()Landroid/net/ConnectivityManager;", "setConnectivityManager", "(Landroid/net/ConnectivityManager;)V", "connectivityManagerCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "validNetworkConnections", "Ljava/util/ArrayList;", "Landroid/net/Network;", "Lkotlin/collections/ArrayList;", "getValidNetworkConnections", "()Ljava/util/ArrayList;", "getConnectivityCallbacks", "onActive", "", "onInactive", "Companion", "InternetAvailability", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
public final class NetworkStatusHelper
extends LiveData<NetworkStatus> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ConnectivityManager connectivityManager;
    private ConnectivityManager.NetworkCallback connectivityManagerCallback;
    @NotNull
    private final ArrayList<Network> validNetworkConnections;
    public static final int $stable = 8;
    private static boolean isConnected = true;

    public NetworkStatusHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
        this.validNetworkConnections = new ArrayList();
    }

    @NotNull
    public final ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    public final void setConnectivityManager(@NotNull ConnectivityManager connectivityManager) {
        Intrinsics.checkNotNullParameter((Object)connectivityManager, (String)"<set-?>");
        this.connectivityManager = connectivityManager;
    }

    @NotNull
    public final ArrayList<Network> getValidNetworkConnections() {
        return this.validNetworkConnections;
    }

    private final ConnectivityManager.NetworkCallback getConnectivityCallbacks() {
        return new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkStatusHelper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                boolean hasNetworkConnection;
                NetworkCapabilities networkCapability;
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                NetworkCapabilities networkCapabilities = networkCapability = this.this$0.getConnectivityManager().getNetworkCapabilities(network);
                boolean bl = hasNetworkConnection = networkCapabilities != null ? networkCapabilities.hasCapability(12) : false;
                if (hasNetworkConnection) {
                    this.determineInternetAccess(network);
                }
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                this.this$0.getValidNetworkConnections().remove(network);
                this.announceNetworkStatus();
            }

            private final void determineInternetAccess(Network network) {
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, network, this, null){
                    int label;
                    final /* synthetic */ NetworkStatusHelper this$0;
                    final /* synthetic */ Network $network;
                    final /* synthetic */ getConnectivityCallbacks.1 this$1;
                    {
                        this.this$0 = $receiver;
                        this.$network = $network;
                        this.this$1 = $receiver2;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (!InternetAvailability.INSTANCE.check()) return Unit.INSTANCE;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$network, this.this$1, null){
                                    int label;
                                    final /* synthetic */ NetworkStatusHelper this$0;
                                    final /* synthetic */ Network $network;
                                    final /* synthetic */ getConnectivityCallbacks.1 this$1;
                                    {
                                        this.this$0 = $receiver;
                                        this.$network = $network;
                                        this.this$1 = $receiver2;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.this$0.getValidNetworkConnections().add(this.$network);
                                                this.this$1.announceNetworkStatus();
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            public final void announceNetworkStatus() {
                if (!((Collection)this.this$0.getValidNetworkConnections()).isEmpty()) {
                    NetworkStatusHelper.access$postValue(this.this$0, NetworkStatus.Available);
                    NetworkStatusHelper.Companion.setConnected(true);
                } else {
                    NetworkStatusHelper.access$postValue(this.this$0, NetworkStatus.Unavailable);
                    NetworkStatusHelper.Companion.setConnected(false);
                }
            }
        };
    }

    protected void onActive() {
        super.onActive();
        this.connectivityManagerCallback = this.getConnectivityCallbacks();
        NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
        ConnectivityManager.NetworkCallback networkCallback = this.connectivityManagerCallback;
        if (networkCallback == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManagerCallback");
            networkCallback = null;
        }
        this.connectivityManager.registerNetworkCallback(networkRequest, networkCallback);
    }

    protected void onInactive() {
        super.onInactive();
        ConnectivityManager.NetworkCallback networkCallback = this.connectivityManagerCallback;
        if (networkCallback == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectivityManagerCallback");
            networkCallback = null;
        }
        this.connectivityManager.unregisterNetworkCallback(networkCallback);
    }

    public static final /* synthetic */ void access$postValue(NetworkStatusHelper $this, NetworkStatus p0) {
        $this.postValue((Object)p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"LNetworkStatusHelper$Companion;", "", "()V", "isConnected", "", "()Z", "setConnected", "(Z)V", "sdk_internalRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isConnected() {
            return isConnected;
        }

        public final void setConnected(boolean bl) {
            isConnected = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"LNetworkStatusHelper$InternetAvailability;", "", "()V", "check", "", "sdk_internalRelease"})
    @StabilityInferred(parameters=1)
    public static final class InternetAvailability {
        @NotNull
        public static final InternetAvailability INSTANCE = new InternetAvailability();
        public static final int $stable;

        private InternetAvailability() {
        }

        public final boolean check() {
            boolean bl;
            try {
                URL url = new URL("https://clients3.google.com/generate_204");
                URLConnection uRLConnection = url.openConnection();
                Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                HttpURLConnection urlc = (HttpURLConnection)uRLConnection;
                urlc.setRequestProperty("User-Agent", "Android");
                urlc.setRequestProperty("Connection", "close");
                urlc.setConnectTimeout(5000);
                urlc.connect();
                bl = urlc.getResponseCode() == 204 && urlc.getContentLength() == 0;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }
    }
}

