/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.core.ui;

import android.content.Context;
import android.preference.PreferenceManager;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/brightwell/readyremit/sdk/core/ui/LocaleConfigurator;", "", "()V", "getDefaultLanguage", "", "context", "Landroid/content/Context;", "setLocaleLanguage", "languageCode", "sdk_internalRelease"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nLocaleConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocaleConfigurator.kt\ncom/brightwell/readyremit/sdk/core/ui/LocaleConfigurator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,72:1\n12474#2,2:73\n*S KotlinDebug\n*F\n+ 1 LocaleConfigurator.kt\ncom/brightwell/readyremit/sdk/core/ui/LocaleConfigurator\n*L\n55#1:73,2\n*E\n"})
public final class LocaleConfigurator {
    public static final int $stable;

    @Inject
    public LocaleConfigurator() {
    }

    @NotNull
    public final String getDefaultLanguage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return String.valueOf(PreferenceManager.getDefaultSharedPreferences((Context)context).getString("language", "en"));
    }

    @NotNull
    public final Context setLocaleLanguage(@NotNull Context context, @NotNull String languageCode2) {
        Locale locale;
        String langCode;
        boolean bl;
        String localeCode;
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)languageCode2, (String)"languageCode");
            String string2 = StringsKt.replace$default((String)languageCode2, (String)"-", (String)"_", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            localeCode = string2;
            Locale[] localeArray = Locale.getAvailableLocales();
            Intrinsics.checkNotNullExpressionValue((Object)localeArray, (String)"getAvailableLocales(...)");
            Object[] $this$any$iv = localeArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Locale it = (Locale)element$iv;
                boolean bl2 = false;
                String string3 = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)string4, (Object)localeCode)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        boolean isLocaleCodeAlreadyAvailable = bl;
        String string5 = langCode = isLocaleCodeAlreadyAvailable ? localeCode : "en";
        if (StringsKt.contains$default((CharSequence)langCode, (char)'_', (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"_"};
            List splitLocaleValue = StringsKt.split$default((CharSequence)langCode, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            locale = new Locale((String)splitLocaleValue.get(0), (String)splitLocaleValue.get(1));
        } else {
            locale = new Locale(langCode);
        }
        Locale updatedLocale = locale;
        Locale.setDefault(updatedLocale);
        context.getResources().getConfiguration().setLocale(updatedLocale);
        PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putString("language", updatedLocale.getLanguage()).apply();
        Context context2 = context.createConfigurationContext(context.getResources().getConfiguration());
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"createConfigurationContext(...)");
        return context2;
    }
}

