/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.components.confetti;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import com.brightwell.readyremit.sdk.internal.components.confetti.ConfettiSource;
import com.brightwell.readyremit.sdk.internal.components.confetti.ConfettiView;
import com.brightwell.readyremit.sdk.internal.components.confetti.ConfettoGenerator;
import com.brightwell.readyremit.sdk.internal.components.confetti.confetto.Confetto;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;

public class ConfettiManager {
    public static final long INFINITE_DURATION = Long.MAX_VALUE;
    private final Random random = new Random();
    private final ConfettoGenerator confettoGenerator;
    private final ConfettiSource confettiSource;
    private final ViewGroup parentView;
    private final ConfettiView confettiView;
    private final Queue<Confetto> recycledConfetti = new LinkedList<Confetto>();
    private final List<Confetto> confetti = new ArrayList<Confetto>(300);
    private ValueAnimator animator;
    private long lastEmittedTimestamp;
    private int numInitialCount;
    private long emissionDuration;
    private float emissionRate;
    private float emissionRateInverse;
    private Interpolator fadeOutInterpolator;
    private Rect bound;
    private float velocityX;
    private float velocityDeviationX;
    private float velocityY;
    private float velocityDeviationY;
    private float accelerationX;
    private float accelerationDeviationX;
    private float accelerationY;
    private float accelerationDeviationY;
    private Float targetVelocityX;
    private Float targetVelocityXDeviation;
    private Float targetVelocityY;
    private Float targetVelocityYDeviation;
    private int initialRotation;
    private int initialRotationDeviation;
    private float rotationalVelocity;
    private float rotationalVelocityDeviation;
    private float rotationalAcceleration;
    private float rotationalAccelerationDeviation;
    private Float targetRotationalVelocity;
    private Float targetRotationalVelocityDeviation;
    private long ttl;
    private ConfettiAnimationListener animationListener;

    public ConfettiManager(Context context, ConfettoGenerator confettoGenerator, ConfettiSource confettiSource, ViewGroup parentView) {
        this(confettoGenerator, confettiSource, parentView, ConfettiView.newInstance(context));
    }

    public ConfettiManager(ConfettoGenerator confettoGenerator, ConfettiSource confettiSource, ViewGroup parentView, ConfettiView confettiView) {
        this.confettoGenerator = confettoGenerator;
        this.confettiSource = confettiSource;
        this.parentView = parentView;
        this.confettiView = confettiView;
        this.confettiView.bind(this.confetti);
        this.confettiView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
            }

            public void onViewDetachedFromWindow(View v) {
                ConfettiManager.this.terminate();
            }
        });
        this.ttl = -1L;
        this.bound = new Rect(0, 0, parentView.getWidth(), parentView.getHeight());
    }

    public ConfettiManager setNumInitialCount(int numInitialCount) {
        this.numInitialCount = numInitialCount;
        return this;
    }

    public ConfettiManager setEmissionDuration(long emissionDurationInMillis) {
        this.emissionDuration = emissionDurationInMillis;
        return this;
    }

    public ConfettiManager setEmissionRate(float emissionRate) {
        this.emissionRate = emissionRate / 1000.0f;
        this.emissionRateInverse = 1.0f / this.emissionRate;
        return this;
    }

    public ConfettiManager setVelocityX(float velocityX) {
        return this.setVelocityX(velocityX, 0.0f);
    }

    public ConfettiManager setVelocityX(float velocityX, float velocityDeviationX) {
        this.velocityX = velocityX / 1000.0f;
        this.velocityDeviationX = velocityDeviationX / 1000.0f;
        return this;
    }

    public ConfettiManager setVelocityY(float velocityY) {
        return this.setVelocityY(velocityY, 0.0f);
    }

    public ConfettiManager setVelocityY(float velocityY, float velocityDeviationY) {
        this.velocityY = velocityY / 1000.0f;
        this.velocityDeviationY = velocityDeviationY / 1000.0f;
        return this;
    }

    public ConfettiManager setAccelerationX(float accelerationX) {
        return this.setAccelerationX(accelerationX, 0.0f);
    }

    public ConfettiManager setAccelerationX(float accelerationX, float accelerationDeviationX) {
        this.accelerationX = accelerationX / 1000000.0f;
        this.accelerationDeviationX = accelerationDeviationX / 1000000.0f;
        return this;
    }

    public ConfettiManager setAccelerationY(float accelerationY) {
        return this.setAccelerationY(accelerationY, 0.0f);
    }

    public ConfettiManager setAccelerationY(float accelerationY, float accelerationDeviationY) {
        this.accelerationY = accelerationY / 1000000.0f;
        this.accelerationDeviationY = accelerationDeviationY / 1000000.0f;
        return this;
    }

    public ConfettiManager setTargetVelocityX(float targetVelocityX) {
        return this.setTargetVelocityX(targetVelocityX, 0.0f);
    }

    public ConfettiManager setTargetVelocityX(float targetVelocityX, float targetVelocityXDeviation) {
        this.targetVelocityX = Float.valueOf(targetVelocityX / 1000.0f);
        this.targetVelocityXDeviation = Float.valueOf(targetVelocityXDeviation / 1000.0f);
        return this;
    }

    public ConfettiManager setTargetVelocityY(float targetVelocityY) {
        return this.setTargetVelocityY(targetVelocityY, 0.0f);
    }

    public ConfettiManager setTargetVelocityY(float targetVelocityY, float targetVelocityYDeviation) {
        this.targetVelocityY = Float.valueOf(targetVelocityY / 1000.0f);
        this.targetVelocityYDeviation = Float.valueOf(targetVelocityYDeviation / 1000.0f);
        return this;
    }

    public ConfettiManager setInitialRotation(int initialRotation) {
        return this.setInitialRotation(initialRotation, 0);
    }

    public ConfettiManager setInitialRotation(int initialRotation, int initialRotationDeviation) {
        this.initialRotation = initialRotation;
        this.initialRotationDeviation = initialRotationDeviation;
        return this;
    }

    public ConfettiManager setRotationalVelocity(float rotationalVelocity) {
        return this.setRotationalVelocity(rotationalVelocity, 0.0f);
    }

    public ConfettiManager setRotationalVelocity(float rotationalVelocity, float rotationalVelocityDeviation) {
        this.rotationalVelocity = rotationalVelocity / 1000.0f;
        this.rotationalVelocityDeviation = rotationalVelocityDeviation / 1000.0f;
        return this;
    }

    public ConfettiManager setRotationalAcceleration(float rotationalAcceleration) {
        return this.setRotationalAcceleration(rotationalAcceleration, 0.0f);
    }

    public ConfettiManager setRotationalAcceleration(float rotationalAcceleration, float rotationalAccelerationDeviation) {
        this.rotationalAcceleration = rotationalAcceleration / 1000000.0f;
        this.rotationalAccelerationDeviation = rotationalAccelerationDeviation / 1000000.0f;
        return this;
    }

    public ConfettiManager setTargetRotationalVelocity(float targetRotationalVelocity) {
        return this.setTargetRotationalVelocity(targetRotationalVelocity, 0.0f);
    }

    public ConfettiManager setTargetRotationalVelocity(float targetRotationalVelocity, float targetRotationalVelocityDeviation) {
        this.targetRotationalVelocity = Float.valueOf(targetRotationalVelocity / 1000.0f);
        this.targetRotationalVelocityDeviation = Float.valueOf(targetRotationalVelocityDeviation / 1000.0f);
        return this;
    }

    public ConfettiManager setBound(Rect bound) {
        this.bound = bound;
        return this;
    }

    public ConfettiManager setTTL(long ttlInMillis) {
        this.ttl = ttlInMillis;
        return this;
    }

    public ConfettiManager enableFadeOut(Interpolator fadeOutInterpolator) {
        this.fadeOutInterpolator = fadeOutInterpolator;
        return this;
    }

    public ConfettiManager disableFadeOut() {
        this.fadeOutInterpolator = null;
        return this;
    }

    public ConfettiManager setTouchEnabled(boolean touchEnabled) {
        this.confettiView.setTouchEnabled(touchEnabled);
        return this;
    }

    public ConfettiManager setConfettiAnimationListener(ConfettiAnimationListener listener) {
        this.animationListener = listener;
        return this;
    }

    public ConfettiManager animate() {
        if (this.animationListener != null) {
            this.animationListener.onAnimationStart(this);
        }
        this.cleanupExistingAnimation();
        this.attachConfettiViewToParent();
        this.addNewConfetti(this.numInitialCount, 0L);
        this.startNewAnimation();
        return this;
    }

    public void terminate() {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.confettiView.terminate();
        if (this.animationListener != null) {
            this.animationListener.onAnimationEnd(this);
        }
    }

    private void cleanupExistingAnimation() {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.lastEmittedTimestamp = 0L;
        Iterator<Confetto> iterator = this.confetti.iterator();
        while (iterator.hasNext()) {
            this.removeConfetto(iterator.next());
            iterator.remove();
        }
    }

    private void attachConfettiViewToParent() {
        ViewParent currentParent = this.confettiView.getParent();
        if (currentParent != null) {
            if (currentParent != this.parentView) {
                ((ViewGroup)currentParent).removeView((View)this.confettiView);
                this.parentView.addView((View)this.confettiView);
            }
        } else {
            this.parentView.addView((View)this.confettiView);
        }
        this.confettiView.reset();
    }

    private void addNewConfetti(int numConfetti, long initialDelay) {
        for (int i2 = 0; i2 < numConfetti; ++i2) {
            Confetto confetto = this.recycledConfetti.poll();
            if (confetto == null) {
                confetto = this.confettoGenerator.generateConfetto(this.random);
            }
            confetto.reset();
            this.configureConfetto(confetto, this.confettiSource, this.random, initialDelay);
            confetto.prepare(this.bound);
            this.addConfetto(confetto);
        }
    }

    private void startNewAnimation() {
        this.animator = ValueAnimator.ofInt((int[])new int[]{0}).setDuration(Long.MAX_VALUE);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                long elapsedTime = valueAnimator.getCurrentPlayTime();
                ConfettiManager.this.processNewEmission(elapsedTime);
                ConfettiManager.this.updateConfetti(elapsedTime);
                if (ConfettiManager.this.confetti.size() == 0 && elapsedTime >= ConfettiManager.this.emissionDuration) {
                    ConfettiManager.this.terminate();
                } else {
                    ConfettiManager.this.confettiView.invalidate();
                }
            }
        });
        this.animator.start();
    }

    private void processNewEmission(long elapsedTime) {
        if (elapsedTime < this.emissionDuration) {
            if (this.lastEmittedTimestamp == 0L) {
                this.lastEmittedTimestamp = elapsedTime;
            } else {
                long timeSinceLastEmission = elapsedTime - this.lastEmittedTimestamp;
                int numNewConfetti = (int)(this.random.nextFloat() * this.emissionRate * (float)timeSinceLastEmission);
                if (numNewConfetti > 0) {
                    this.lastEmittedTimestamp += (long)Math.round(this.emissionRateInverse * (float)numNewConfetti);
                    this.addNewConfetti(numNewConfetti, elapsedTime);
                }
            }
        }
    }

    private void updateConfetti(long elapsedTime) {
        Iterator<Confetto> iterator = this.confetti.iterator();
        while (iterator.hasNext()) {
            Confetto confetto = iterator.next();
            if (confetto.applyUpdate(elapsedTime)) continue;
            iterator.remove();
            this.removeConfetto(confetto);
        }
    }

    private void addConfetto(Confetto confetto) {
        this.confetti.add(confetto);
        if (this.animationListener != null) {
            this.animationListener.onConfettoEnter(confetto);
        }
    }

    private void removeConfetto(Confetto confetto) {
        if (this.animationListener != null) {
            this.animationListener.onConfettoExit(confetto);
        }
        this.recycledConfetti.add(confetto);
    }

    protected void configureConfetto(Confetto confetto, ConfettiSource confettiSource, Random random, long initialDelay) {
        confetto.setInitialDelay(initialDelay);
        confetto.setInitialX(confettiSource.getInitialX(random.nextFloat()));
        confetto.setInitialY(confettiSource.getInitialY(random.nextFloat()));
        confetto.setInitialVelocityX(this.getVarianceAmount(this.velocityX, this.velocityDeviationX, random));
        confetto.setInitialVelocityY(this.getVarianceAmount(this.velocityY, this.velocityDeviationY, random));
        confetto.setAccelerationX(this.getVarianceAmount(this.accelerationX, this.accelerationDeviationX, random));
        confetto.setAccelerationY(this.getVarianceAmount(this.accelerationY, this.accelerationDeviationY, random));
        confetto.setTargetVelocityX(this.targetVelocityX == null ? null : Float.valueOf(this.getVarianceAmount(this.targetVelocityX.floatValue(), this.targetVelocityXDeviation.floatValue(), random)));
        confetto.setTargetVelocityY(this.targetVelocityY == null ? null : Float.valueOf(this.getVarianceAmount(this.targetVelocityY.floatValue(), this.targetVelocityYDeviation.floatValue(), random)));
        confetto.setInitialRotation(this.getVarianceAmount(this.initialRotation, this.initialRotationDeviation, random));
        confetto.setInitialRotationalVelocity(this.getVarianceAmount(this.rotationalVelocity, this.rotationalVelocityDeviation, random));
        confetto.setRotationalAcceleration(this.getVarianceAmount(this.rotationalAcceleration, this.rotationalAccelerationDeviation, random));
        confetto.setTargetRotationalVelocity(this.targetRotationalVelocity == null ? null : Float.valueOf(this.getVarianceAmount(this.targetRotationalVelocity.floatValue(), this.targetRotationalVelocityDeviation.floatValue(), random)));
        confetto.setTTL(this.ttl);
        confetto.setFadeOut(this.fadeOutInterpolator);
    }

    private float getVarianceAmount(float base, float deviation, Random random) {
        return base + deviation * (random.nextFloat() * 2.0f - 1.0f);
    }

    public static interface ConfettiAnimationListener {
        public void onAnimationStart(ConfettiManager var1);

        public void onAnimationEnd(ConfettiManager var1);

        public void onConfettoEnter(Confetto var1);

        public void onConfettoExit(Confetto var1);
    }

    public static class ConfettiAnimationListenerAdapter
    implements ConfettiAnimationListener {
        @Override
        public void onAnimationStart(ConfettiManager confettiManager) {
        }

        @Override
        public void onAnimationEnd(ConfettiManager confettiManager) {
        }

        @Override
        public void onConfettoEnter(Confetto confetto) {
        }

        @Override
        public void onConfettoExit(Confetto confetto) {
        }
    }
}

