/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.components.confetti;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.components.confetti.confetto.Confetto;
import java.util.List;

public class ConfettiView
extends View
implements View.OnLayoutChangeListener {
    private List<Confetto> confetti;
    private boolean terminated;
    private boolean touchEnabled;
    private Confetto draggedConfetto;

    public static ConfettiView newInstance(Context context) {
        ConfettiView confettiView = new ConfettiView(context, null);
        confettiView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        int defaultElevation = context.getResources().getDimensionPixelOffset(R.dimen.confetti_default_elevation);
        confettiView.setElevation(defaultElevation);
        return confettiView;
    }

    public ConfettiView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void bind(List<Confetto> confetti) {
        this.confetti = confetti;
    }

    public void setTouchEnabled(boolean touchEnabled) {
        this.touchEnabled = touchEnabled;
    }

    public void terminate() {
        if (!this.terminated) {
            this.terminated = true;
            this.getParent().requestLayout();
        }
    }

    public void reset() {
        this.terminated = false;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        parent.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (this.confetti == null) {
            this.terminate();
        }
    }

    public void onLayoutChange(View view, int i2, int i1, int i22, int i3, int i4, int i5, int i6, int i7) {
        ViewParent parent;
        if (this.terminated && (parent = this.getParent()) instanceof ViewGroup) {
            ViewGroup vg = (ViewGroup)parent;
            vg.removeViewInLayout((View)this);
            vg.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            vg.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (!this.terminated) {
            canvas.save();
            for (Confetto confetto : this.confetti) {
                confetto.draw(canvas);
            }
            canvas.restore();
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        boolean handled = false;
        if (this.touchEnabled) {
            block0 : switch (event.getAction()) {
                case 0: {
                    for (Confetto confetto : this.confetti) {
                        if (!confetto.onTouchDown(event)) continue;
                        this.draggedConfetto = confetto;
                        handled = true;
                        break block0;
                    }
                    break;
                }
                case 2: {
                    if (this.draggedConfetto == null) break;
                    this.draggedConfetto.onTouchMove(event);
                    handled = true;
                    break;
                }
                case 1: 
                case 3: {
                    if (this.draggedConfetto == null) break;
                    this.draggedConfetto.onTouchUp(event);
                    this.draggedConfetto = null;
                    handled = true;
                }
            }
        }
        return handled || super.onTouchEvent(event);
    }
}

