/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.components.confetti;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;

public class Utils {
    private static final Paint PAINT = new Paint();
    private static Interpolator defaultAlphaInterpolator;

    public static Interpolator getDefaultAlphaInterpolator() {
        if (defaultAlphaInterpolator == null) {
            defaultAlphaInterpolator = new Interpolator(){

                public float getInterpolation(float v) {
                    return v >= 0.9f ? 1.0f - (v - 0.9f) * 10.0f : 1.0f;
                }
            };
        }
        return defaultAlphaInterpolator;
    }

    public static List<Bitmap> generateConfettiBitmaps(int[] colors, int size) {
        ArrayList<Bitmap> bitmaps = new ArrayList<Bitmap>();
        for (int color : colors) {
            bitmaps.add(Utils.createCircleBitmap(color, size));
            bitmaps.add(Utils.createSquareBitmap(color, size));
            bitmaps.add(Utils.createTriangleBitmap(color, size));
        }
        return bitmaps;
    }

    public static Bitmap createCircleBitmap(int color, int size) {
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        PAINT.setColor(color);
        float radius = (float)size / 2.0f;
        canvas.drawCircle(radius, radius, radius, PAINT);
        return bitmap;
    }

    public static Bitmap createSquareBitmap(int color, int size) {
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        PAINT.setColor(color);
        Path path = new Path();
        path.moveTo(0.0f, 0.0f);
        path.lineTo((float)size, 0.0f);
        path.lineTo((float)size, (float)size);
        path.lineTo(0.0f, (float)size);
        path.close();
        canvas.drawPath(path, PAINT);
        return bitmap;
    }

    public static Bitmap createTriangleBitmap(int color, int size) {
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        PAINT.setColor(color);
        Path path = new Path();
        float point = (float)Math.tan(0.26179939560137916) * (float)size;
        path.moveTo(0.0f, 0.0f);
        path.lineTo((float)size, point);
        path.lineTo(point, (float)size);
        path.close();
        canvas.drawPath(path, PAINT);
        return bitmap;
    }

    static {
        PAINT.setStyle(Paint.Style.FILL);
    }
}

