/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.components.confetti.confetto;

import android.animation.ArgbEvaluator;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.SystemClock;
import com.brightwell.readyremit.sdk.internal.components.confetti.confetto.BitmapConfetto;
import java.util.Random;

public class ShimmeringConfetto
extends BitmapConfetto {
    private final ArgbEvaluator evaluator = new ArgbEvaluator();
    private final int fromColor;
    private final int toColor;
    private final long waveLength;
    private final long halfWaveLength;
    private final long randomStart;

    public ShimmeringConfetto(Bitmap bitmap, int fromColor, int toColor, long waveLength, Random random) {
        super(bitmap);
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.waveLength = waveLength;
        this.halfWaveLength = waveLength / 2L;
        int currentTime = Math.abs((int)SystemClock.elapsedRealtime());
        this.randomStart = currentTime - random.nextInt(currentTime);
    }

    @Override
    protected void drawInternal(Canvas canvas, Matrix matrix, Paint paint, float x, float y, float rotation, float percentageAnimated) {
        long currTime = SystemClock.elapsedRealtime();
        long fraction = (currTime - this.randomStart) % this.waveLength;
        float animated = fraction < this.halfWaveLength ? (float)fraction / (float)this.halfWaveLength : ((float)this.waveLength - (float)fraction) / (float)this.halfWaveLength;
        int color = (Integer)this.evaluator.evaluate(animated, (Object)this.fromColor, (Object)this.toColor);
        PorterDuffColorFilter colorFilter = new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_ATOP);
        paint.setColorFilter((ColorFilter)colorFilter);
        super.drawInternal(canvas, matrix, paint, x, y, rotation, percentageAnimated);
    }
}

