/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.di.module;

import android.app.Application;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.environment.Environment;
import com.brightwell.readyremit.sdk.environment.EnvironmentKt;
import com.brightwell.readyremit.sdk.internal.api.TransferApi;
import com.brightwell.readyremit.sdk.internal.api.data.InputField;
import com.brightwell.readyremit.sdk.internal.api.data.OutputField;
import com.brightwell.readyremit.sdk.internal.api.internals.ApiCallAdapterFactory;
import com.brightwell.readyremit.sdk.internal.api.internals.AuthInterceptor;
import com.brightwell.readyremit.sdk.internal.api.internals.RequestInterceptor;
import com.brightwell.readyremit.sdk.ui.transfer.useCase.FetchMultipleQuotesUseCase;
import com.brightwell.readyremit.sdk.utils.DispatcherProvider;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.adapters.PolymorphicJsonAdapterFactory;
import dagger.Module;
import dagger.Provides;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Module
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0007J\b\u0010\u001d\u001a\u00020\u001aH\u0007\u00a8\u0006\u001e"}, d2={"Lcom/brightwell/readyremit/sdk/internal/di/module/SDKModule;", "", "()V", "provideAuthInterceptor", "Lcom/brightwell/readyremit/sdk/internal/api/internals/AuthInterceptor;", "provideFetchMultipleQuotesUseCase", "Lcom/brightwell/readyremit/sdk/ui/transfer/useCase/FetchMultipleQuotesUseCase;", "transferApi", "Lcom/brightwell/readyremit/sdk/internal/api/TransferApi;", "provideHttpInterceptor", "Lokhttp3/logging/HttpLoggingInterceptor;", "provideOkHttpClient", "Lokhttp3/OkHttpClient;", "authInterceptor", "requestInterceptor", "Lcom/brightwell/readyremit/sdk/internal/api/internals/RequestInterceptor;", "httpLoggingInterceptor", "provideRequestInterceptor", "application", "Landroid/app/Application;", "provideRetrofit", "Lretrofit2/Retrofit;", "environment", "Lcom/brightwell/readyremit/sdk/environment/Environment;", "okHttpClient", "moshi", "Lcom/squareup/moshi/Moshi;", "provideTransferApi", "retrofit", "providesMoshi", "sdk_internalRelease"})
@StabilityInferred(parameters=1)
public final class SDKModule {
    public static final int $stable;

    @Provides
    @Singleton
    @NotNull
    public final OkHttpClient provideOkHttpClient(@NotNull AuthInterceptor authInterceptor, @NotNull RequestInterceptor requestInterceptor, @NotNull HttpLoggingInterceptor httpLoggingInterceptor) {
        Intrinsics.checkNotNullParameter((Object)authInterceptor, (String)"authInterceptor");
        Intrinsics.checkNotNullParameter((Object)requestInterceptor, (String)"requestInterceptor");
        Intrinsics.checkNotNullParameter((Object)httpLoggingInterceptor, (String)"httpLoggingInterceptor");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)requestInterceptor).addInterceptor((Interceptor)httpLoggingInterceptor).addInterceptor((Interceptor)authInterceptor);
        return builder.build();
    }

    @Provides
    @Singleton
    @NotNull
    public final RequestInterceptor provideRequestInterceptor(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        return new RequestInterceptor(application);
    }

    @Provides
    @Singleton
    @NotNull
    public final AuthInterceptor provideAuthInterceptor() {
        return new AuthInterceptor();
    }

    @Provides
    @Singleton
    @NotNull
    public final HttpLoggingInterceptor provideHttpInterceptor() {
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor(null, 1, null);
        interceptor.level(HttpLoggingInterceptor.Level.NONE);
        return interceptor;
    }

    @Provides
    @Singleton
    @NotNull
    public final Moshi providesMoshi() {
        PolymorphicJsonAdapterFactory fieldFactory = PolymorphicJsonAdapterFactory.of(OutputField.class, (String)"type").withSubtype(OutputField.Text.class, "TEXT").withSubtype(OutputField.Dropdown.class, "DROPDOWN").withSubtype(OutputField.Phone.class, "PHONE_NUMBER").withDefaultValue((Object)new OutputField.Unhandled());
        PolymorphicJsonAdapterFactory inputFieldFactory = PolymorphicJsonAdapterFactory.of(InputField.class, (String)"fieldType").withSubtype(InputField.Text.class, "TEXT").withSubtype(InputField.Dropdown.class, "DROPDOWN").withSubtype(InputField.Phone.class, "PHONE_NUMBER").withDefaultValue((Object)new InputField.Unhandled());
        Moshi moshi = new Moshi.Builder().add((JsonAdapter.Factory)fieldFactory).add((JsonAdapter.Factory)inputFieldFactory).build();
        Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
        return moshi;
    }

    @Provides
    @NotNull
    public final Retrofit provideRetrofit(@NotNull Application application, @NotNull Environment environment, @NotNull OkHttpClient okHttpClient, @NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        Retrofit retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(EnvironmentKt.getTransferApiBaseUrl(environment)).addCallAdapterFactory((CallAdapter.Factory)new ApiCallAdapterFactory()).addConverterFactory((Converter.Factory)MoshiConverterFactory.create((Moshi)moshi)).build();
        Intrinsics.checkNotNullExpressionValue((Object)retrofit, (String)"build(...)");
        return retrofit;
    }

    @Provides
    @NotNull
    public final TransferApi provideTransferApi(@NotNull Retrofit retrofit) {
        Intrinsics.checkNotNullParameter((Object)retrofit, (String)"retrofit");
        Object object = retrofit.create(TransferApi.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(...)");
        return (TransferApi)object;
    }

    @Provides
    @NotNull
    public final FetchMultipleQuotesUseCase provideFetchMultipleQuotesUseCase(@NotNull TransferApi transferApi) {
        Intrinsics.checkNotNullParameter((Object)transferApi, (String)"transferApi");
        return new FetchMultipleQuotesUseCase(transferApi, new DispatcherProvider());
    }
}

