/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.input;

import android.content.Context;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.StringRes;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.content.ContextExtKt;
import com.brightwell.readyremit.sdk.internal.input.ToolTipDialog;
import com.brightwell.readyremit.sdk.internal.input.widget.FocusMirror;
import com.brightwell.readyremit.sdk.internal.input.widget.HasValidationState;
import com.brightwell.readyremit.sdk.internal.input.widget.InputTextView;
import com.brightwell.readyremit.sdk.internal.input.widget.ValidationState;
import com.brightwell.readyremit.sdk.internal.view.TextViewExtKt;
import com.brightwell.readyremit.sdk.internal.view.ViewExtKt;
import com.brightwell.readyremit.sdk.internal.view.ViewStubExtKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u001d\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010@\u001a\u00020AJ\u0012\u0010B\u001a\u00020A2\b\b\u0002\u0010C\u001a\u00020 H\u0004J\b\u0010D\u001a\u00020AH\u0014J\u0010\u0010E\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0017H\u0004J\u0010\u0010G\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0019H\u0004J\b\u0010H\u001a\u00020AH\u0002J\u0010\u0010I\u001a\u00020A2\u0006\u0010J\u001a\u00020?H\u0004J\b\u0010K\u001a\u00020AH\u0002J\u0010\u0010\u000e\u001a\u00020A2\b\b\u0001\u0010L\u001a\u00020\u0005J\u0010\u0010M\u001a\u00020A2\u0006\u0010N\u001a\u00020 H\u0016J\u0010\u0010-\u001a\u00020A2\b\b\u0001\u0010L\u001a\u00020\u0005J\b\u0010O\u001a\u00020AH\u0002J\u000e\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020\nJ\u0010\u0010P\u001a\u00020A2\b\b\u0001\u0010L\u001a\u00020\u0005J\u0012\u0010R\u001a\u00020A2\b\b\u0002\u0010C\u001a\u00020 H\u0004J\u000e\u0010S\u001a\u00020A2\u0006\u0010Q\u001a\u00020\nJ\u0010\u0010S\u001a\u00020A2\b\b\u0001\u0010L\u001a\u00020\u0005J\u0010\u0010T\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0017H\u0004J\u0010\u0010U\u001a\u00020A2\u0006\u0010F\u001a\u00020\u0019H\u0004J\u0010\u0010V\u001a\u00020A2\u0006\u0010J\u001a\u00020?H\u0004J\b\u0010W\u001a\u00020AH\u0002J\b\u0010X\u001a\u00020AH\u0002J\b\u0010Y\u001a\u00020AH\u0002J\b\u0010Z\u001a\u00020AH\u0002J\u0018\u0010[\u001a\u00020A2\u0006\u0010\\\u001a\u0002052\u0006\u0010]\u001a\u00020\u001bH\u0002R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020 2\u0006\u0010\t\u001a\u00020 @FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\u000e\u0010'\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010+\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\r\"\u0004\b-\u0010\u000fR\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u00020 2\u0006\u0010\t\u001a\u00020 @DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010!\"\u0004\b3\u0010#R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010;\u001a\u00020:2\u0006\u0010\t\u001a\u00020:@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b<\u0010=R\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/brightwell/readyremit/sdk/internal/input/InputField;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "inputFieldLayoutResId", "", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;ILandroid/util/AttributeSet;)V", "value", "", "assistiveText", "getAssistiveText", "()Ljava/lang/CharSequence;", "setAssistiveText", "(Ljava/lang/CharSequence;)V", "buttonMoreAssistance", "Landroid/widget/Button;", "effectiveLabelText", "getEffectiveLabelText", "setEffectiveLabelText", "enabledMirrors", "", "Landroid/view/View;", "focusMirrors", "Lcom/brightwell/readyremit/sdk/internal/input/widget/FocusMirror;", "iconError", "Landroid/widget/ImageView;", "getIconError", "()Landroid/widget/ImageView;", "iconSuccess", "isOptional", "", "()Z", "setOptional", "(Z)V", "isPreDrawListenerRegistered", "isRequired", "setRequired", "isShowingLabel", "labelAnimationDuration", "", "labelRequiredIndicatorColor", "labelText", "getLabelText", "setLabelText", "preDrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "requiresAssistiveTextMoreDisplayUpdate", "shouldMirrorFocused", "getShouldMirrorFocused", "setShouldMirrorFocused", "textAssistance", "Landroid/widget/TextView;", "textError", "textLabel", "Lcom/brightwell/readyremit/sdk/internal/input/widget/InputTextView;", "textSuccess", "Lcom/brightwell/readyremit/sdk/internal/input/widget/ValidationState;", "validationState", "setValidationState", "(Lcom/brightwell/readyremit/sdk/internal/input/widget/ValidationState;)V", "validationStateHolders", "Lcom/brightwell/readyremit/sdk/internal/input/widget/HasValidationState;", "clearValidationText", "", "hideLabel", "animated", "onEffectiveLabelValueChanged", "registerEnabledMirror", "mirror", "registerFocusMirror", "registerPreDrawListener", "registerValidationStateHolder", "validationStateHolder", "resetAssistiveTextMoreDisplay", "textResId", "setEnabled", "enabled", "showAssistiveTextDialog", "showErrorText", "text", "showLabel", "showSuccessText", "unregisterEnabledMirror", "unregisterFocusMirror", "unregisterValidationStateHolder", "updateAssistiveTextMoreDisplay", "updateEffectiveLabelValue", "updateErrorIconPosition", "updateSuccessIconPosition", "updateValidationIconPosition", "textView", "imageView", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nInputField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InputField.kt\ncom/brightwell/readyremit/sdk/internal/input/InputField\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 View.kt\nandroidx/core/view/ViewKt\n+ 5 AnyExt.kt\ncom/brightwell/readyremit/sdk/utils/AnyExtKt\n*L\n1#1,351:1\n1855#2,2:352\n1855#2,2:354\n1855#2,2:356\n1#3:358\n65#4,2:359\n65#4,4:362\n37#4:366\n53#4:367\n72#4:368\n68#4:369\n37#4:370\n53#4:371\n72#4:372\n3#5:361\n*S KotlinDebug\n*F\n+ 1 InputField.kt\ncom/brightwell/readyremit/sdk/internal/input/InputField\n*L\n46#1:352,2\n52#1:354,2\n123#1:356,2\n305#1:359,2\n313#1:362,4\n313#1:366\n313#1:367\n313#1:368\n305#1:369\n305#1:370\n305#1:371\n305#1:372\n306#1:361\n*E\n"})
public abstract class InputField
extends ConstraintLayout {
    @NotNull
    private final InputTextView textLabel;
    @NotNull
    private final TextView textError;
    @NotNull
    private final ImageView iconError;
    @NotNull
    private final TextView textSuccess;
    @NotNull
    private final ImageView iconSuccess;
    @NotNull
    private final TextView textAssistance;
    @NotNull
    private final Button buttonMoreAssistance;
    private boolean isOptional;
    @NotNull
    private ValidationState validationState;
    private boolean shouldMirrorFocused;
    @Nullable
    private CharSequence effectiveLabelText;
    @NotNull
    private final Set<HasValidationState> validationStateHolders;
    @NotNull
    private final Set<View> enabledMirrors;
    @NotNull
    private final Set<FocusMirror> focusMirrors;
    private final long labelAnimationDuration;
    private final int labelRequiredIndicatorColor;
    private boolean isShowingLabel;
    private boolean requiresAssistiveTextMoreDisplayUpdate;
    private boolean isPreDrawListenerRegistered;
    @NotNull
    private final ViewTreeObserver.OnPreDrawListener preDrawListener;
    private boolean isRequired;
    @Nullable
    private CharSequence labelText;
    public static final int $stable = 8;

    public InputField(@NotNull Context context, int inputFieldLayoutResId, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.validationState = ValidationState.NORMAL;
        this.validationStateHolders = new LinkedHashSet();
        this.enabledMirrors = new LinkedHashSet();
        this.focusMirrors = new LinkedHashSet();
        this.labelAnimationDuration = this.getResources().getInteger(0x10E0000);
        this.labelRequiredIndicatorColor = ContextExtKt.colorFromAttr(context, R.attr.rrmDangerColor, -65536);
        this.isShowingLabel = true;
        this.preDrawListener = new ViewTreeObserver.OnPreDrawListener(this){
            final /* synthetic */ InputField this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onPreDraw() {
                this.this$0.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                InputField.access$setPreDrawListenerRegistered$p(this.this$0, false);
                boolean proceedWithDrawPass = true;
                if (InputField.access$getRequiresAssistiveTextMoreDisplayUpdate$p(this.this$0)) {
                    InputField.access$setRequiresAssistiveTextMoreDisplayUpdate$p(this.this$0, false);
                    InputField.access$updateAssistiveTextMoreDisplay(this.this$0);
                    proceedWithDrawPass = false;
                }
                return proceedWithDrawPass;
            }
        };
        LayoutInflater.from((Context)context).inflate(R.layout.ready_remit_input_field_container, (ViewGroup)this, true);
        ViewStubExtKt.inflateFrom((ViewStub)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_input_field), inputFieldLayoutResId);
        this.textLabel = (InputTextView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_text_input_label);
        this.textError = (TextView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_text_input_error);
        this.iconError = (ImageView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_icon_input_error);
        this.textSuccess = (TextView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_text_input_success);
        this.iconSuccess = (ImageView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_icon_input_success);
        this.textAssistance = (TextView)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_text_input_assistance);
        this.buttonMoreAssistance = (Button)ViewExtKt.findRequiredViewById((View)this, R.id.rrm_button_assistance_more);
        TextViewExtKt.collapseIfEmpty(this.textError);
        TextViewExtKt.collapseIfEmpty(this.textSuccess);
        TextViewExtKt.collapseIfEmpty(this.textAssistance);
        this.registerValidationStateHolder(this.textLabel);
        this.registerEnabledMirror((View)this.textLabel);
        this.registerFocusMirror(this.textLabel);
        this.updateErrorIconPosition();
        this.updateSuccessIconPosition();
        this.buttonMoreAssistance.setOnClickListener(arg_0 -> InputField._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final ImageView getIconError() {
        return this.iconError;
    }

    public final boolean isOptional() {
        return this.isOptional;
    }

    public final void setOptional(boolean bl) {
        this.isOptional = bl;
    }

    private final void setValidationState(ValidationState value) {
        this.validationState = value;
        Iterable $this$forEach$iv = this.validationStateHolders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HasValidationState it = (HasValidationState)element$iv;
            boolean bl = false;
            it.setValidationState(this.validationState);
        }
    }

    protected final boolean getShouldMirrorFocused() {
        return this.shouldMirrorFocused;
    }

    protected final void setShouldMirrorFocused(boolean value) {
        this.shouldMirrorFocused = value;
        Iterable $this$forEach$iv = this.focusMirrors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FocusMirror it = (FocusMirror)element$iv;
            boolean bl = false;
            it.setShouldMirrorFocused(this.shouldMirrorFocused);
        }
    }

    @Nullable
    protected final CharSequence getEffectiveLabelText() {
        return this.effectiveLabelText;
    }

    private final void setEffectiveLabelText(CharSequence value) {
        this.effectiveLabelText = value;
        this.onEffectiveLabelValueChanged();
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.isEnabled()) {
            return;
        }
        super.setEnabled(enabled);
        Iterable $this$forEach$iv = this.enabledMirrors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            View it = (View)element$iv;
            boolean bl = false;
            it.setEnabled(enabled);
        }
        if (this.isRequired) {
            this.updateEffectiveLabelValue();
        }
    }

    public final boolean isRequired() {
        return this.isRequired;
    }

    public final void setRequired(boolean value) {
        block0: {
            Boolean bl = value;
            boolean it = bl;
            boolean bl2 = false;
            Boolean bl3 = it != this.isRequired ? bl : null;
            if (bl3 == null) break block0;
            it = bl3;
            boolean bl4 = false;
            this.isRequired = value;
            this.updateEffectiveLabelValue();
        }
    }

    @Nullable
    public final CharSequence getLabelText() {
        return this.labelText;
    }

    public final void setLabelText(@Nullable CharSequence value) {
        block0: {
            CharSequence charSequence;
            CharSequence it = charSequence = value;
            boolean bl = false;
            CharSequence charSequence2 = !Intrinsics.areEqual((Object)it, (Object)this.labelText) ? charSequence : null;
            if (charSequence2 == null) break block0;
            it = charSequence2;
            boolean bl2 = false;
            this.labelText = value;
            this.updateEffectiveLabelValue();
        }
    }

    public final void setLabelText(@StringRes int textResId) {
        this.setLabelText(this.getContext().getText(textResId));
    }

    public final void showSuccessText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.textError.setText(null);
        ViewExtKt.collapse((View)this.textError);
        ViewExtKt.collapse((View)this.iconError);
        this.textSuccess.setText(text);
        ViewExtKt.show((View)this.textSuccess);
        ViewExtKt.show((View)this.iconSuccess);
        this.updateSuccessIconPosition();
        this.setValidationState(ValidationState.SUCCESS);
    }

    public final void showSuccessText(@StringRes int textResId) {
        String string2 = this.getResources().getString(textResId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.showSuccessText(string2);
    }

    public final void showErrorText(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.textSuccess.setText(null);
        ViewExtKt.collapse((View)this.textSuccess);
        ViewExtKt.collapse((View)this.iconSuccess);
        this.textError.setText(text);
        ViewExtKt.show((View)this.textError);
        ViewExtKt.show((View)this.iconError);
        this.updateErrorIconPosition();
        this.setValidationState(ValidationState.ERROR);
    }

    public final void showErrorText(@StringRes int textResId) {
        String string2 = this.getResources().getString(textResId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        this.showErrorText(string2);
    }

    public final void clearValidationText() {
        this.textSuccess.setText(null);
        ViewExtKt.collapse((View)this.textSuccess);
        ViewExtKt.collapse((View)this.iconSuccess);
        this.textError.setText(null);
        ViewExtKt.collapse((View)this.textError);
        ViewExtKt.collapse((View)this.iconError);
        this.setValidationState(ValidationState.NORMAL);
    }

    @Nullable
    public final CharSequence getAssistiveText() {
        return this.textAssistance.getText();
    }

    public final void setAssistiveText(@Nullable CharSequence value) {
        this.textAssistance.setText(value);
        TextViewExtKt.showOrCollapseIfEmpty(this.textAssistance);
        this.resetAssistiveTextMoreDisplay();
        if (value != null && !StringsKt.isBlank((CharSequence)value)) {
            this.requiresAssistiveTextMoreDisplayUpdate = true;
            this.registerPreDrawListener();
        }
    }

    public final void setAssistiveText(@StringRes int textResId) {
        this.setAssistiveText(this.getContext().getText(textResId));
    }

    protected final void showLabel(boolean animated) {
        if (this.isShowingLabel) {
            return;
        }
        this.isShowingLabel = true;
        InputTextView $this$showLabel_u24lambda_u249 = this.textLabel;
        boolean bl = false;
        if (animated) {
            $this$showLabel_u24lambda_u249.setTextSize(14.0f);
            $this$showLabel_u24lambda_u249.animate().alpha(1.0f).withStartAction(() -> InputField.showLabel$lambda$9$lambda$8($this$showLabel_u24lambda_u249)).setDuration(this.labelAnimationDuration).start();
        } else {
            ViewExtKt.show((View)$this$showLabel_u24lambda_u249);
            $this$showLabel_u24lambda_u249.setTextSize(14.0f);
            $this$showLabel_u24lambda_u249.setAlpha(1.0f);
        }
    }

    public static /* synthetic */ void showLabel$default(InputField inputField, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: showLabel");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        inputField.showLabel(bl);
    }

    protected final void hideLabel(boolean animated) {
        if (!this.isShowingLabel) {
            return;
        }
        this.isShowingLabel = false;
        InputTextView $this$hideLabel_u24lambda_u2411 = this.textLabel;
        boolean bl = false;
        if (animated) {
            $this$hideLabel_u24lambda_u2411.animate().alpha(0.0f).withEndAction(() -> InputField.hideLabel$lambda$11$lambda$10($this$hideLabel_u24lambda_u2411)).setDuration(this.labelAnimationDuration).start();
        } else {
            ViewExtKt.hide((View)$this$hideLabel_u24lambda_u2411);
            $this$hideLabel_u24lambda_u2411.setAlpha(0.0f);
        }
    }

    public static /* synthetic */ void hideLabel$default(InputField inputField, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: hideLabel");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        inputField.hideLabel(bl);
    }

    protected final void registerValidationStateHolder(@NotNull HasValidationState validationStateHolder) {
        Intrinsics.checkNotNullParameter((Object)validationStateHolder, (String)"validationStateHolder");
        if (!this.validationStateHolders.contains(validationStateHolder)) {
            this.validationStateHolders.add(validationStateHolder);
            validationStateHolder.setValidationState(this.validationState);
        }
    }

    protected final void unregisterValidationStateHolder(@NotNull HasValidationState validationStateHolder) {
        Intrinsics.checkNotNullParameter((Object)validationStateHolder, (String)"validationStateHolder");
        this.validationStateHolders.remove(validationStateHolder);
    }

    protected final void registerEnabledMirror(@NotNull View mirror) {
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        if (!this.enabledMirrors.contains(mirror)) {
            this.enabledMirrors.add(mirror);
            mirror.setEnabled(this.isEnabled());
        }
    }

    protected final void unregisterEnabledMirror(@NotNull View mirror) {
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        this.enabledMirrors.remove(mirror);
    }

    protected final void registerFocusMirror(@NotNull FocusMirror mirror) {
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        if (!this.focusMirrors.contains(mirror)) {
            this.focusMirrors.add(mirror);
            mirror.setShouldMirrorFocused(this.shouldMirrorFocused);
        }
    }

    protected final void unregisterFocusMirror(@NotNull FocusMirror mirror) {
        Intrinsics.checkNotNullParameter((Object)mirror, (String)"mirror");
        this.focusMirrors.remove(mirror);
    }

    protected void onEffectiveLabelValueChanged() {
        this.textLabel.setText(this.effectiveLabelText);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateEffectiveLabelValue() {
        CharSequence charSequence;
        InputField inputField;
        block6: {
            block3: {
                Object object;
                block5: {
                    block4: {
                        void it;
                        CharSequence charSequence2;
                        inputField = this;
                        if (!this.isOptional) break block3;
                        CharSequence charSequence3 = charSequence2 = this.labelText;
                        InputField inputField2 = inputField;
                        boolean $i$a$-takeIf-InputField$updateEffectiveLabelValue$22 = false;
                        void var4_6 = it;
                        boolean bl = !(var4_6 == null || StringsKt.isBlank((CharSequence)var4_6));
                        inputField = inputField2;
                        object = bl ? charSequence2 : null;
                        if (object == null) break block4;
                        CharSequence $i$a$-takeIf-InputField$updateEffectiveLabelValue$22 = object;
                        inputField2 = inputField;
                        boolean bl2 = false;
                        String string2 = this.labelText + " " + this.getContext().getString(R.string.rrm_optional);
                        inputField = inputField2;
                        object = string2;
                        if (string2 != null) break block5;
                    }
                    object = "";
                }
                charSequence = object;
                break block6;
            }
            charSequence = this.labelText;
        }
        inputField.setEffectiveLabelText(charSequence);
    }

    private final void updateErrorIconPosition() {
        this.updateValidationIconPosition(this.textSuccess, this.iconSuccess);
    }

    private final void updateSuccessIconPosition() {
        this.updateValidationIconPosition(this.textError, this.iconError);
    }

    private final void updateValidationIconPosition(TextView textView, ImageView imageView) {
        View $this$doOnLayout$iv = (View)textView;
        boolean $i$f$doOnLayout = false;
        if ($this$doOnLayout$iv.isLaidOut() && !$this$doOnLayout$iv.isLayoutRequested()) {
            View it = $this$doOnLayout$iv;
            boolean bl = false;
            TextView $this$requireAs$iv = textView;
            boolean $i$f$requireAs = false;
            TextView textView2 = $this$requireAs$iv;
            if (textView2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
            }
            Layout $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416 = textView2.getLayout();
            boolean bl2 = false;
            if ($this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416 != null) {
                int validationFirstLineTop = $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416.getLineTop(0);
                int validationFirstLineBottom = $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416.getLineBottom(0);
                int validationFirstLineBaseLine = $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416.getLineBaseline(0);
                int offsetFromCenterToBaseline = validationFirstLineBaseLine - (validationFirstLineBottom - validationFirstLineTop) / 2;
                View $this$doOnLayout$iv2 = (View)imageView;
                boolean $i$f$doOnLayout2 = false;
                if ($this$doOnLayout$iv2.isLaidOut() && !$this$doOnLayout$iv2.isLayoutRequested()) {
                    View it2 = $this$doOnLayout$iv2;
                    boolean bl3 = false;
                    ImageView $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = imageView;
                    boolean bl4 = false;
                    $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setBaseline($this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.getHeight() / 2 + offsetFromCenterToBaseline);
                    $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.post(new Runnable($this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414){
                        final /* synthetic */ ImageView $this_with;
                        {
                            this.$this_with = $receiver;
                        }

                        public final void run() {
                            this.$this_with.requestLayout();
                        }
                    });
                } else {
                    View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv2;
                    boolean $i$f$doOnNextLayout = false;
                    $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(imageView, offsetFromCenterToBaseline){
                        final /* synthetic */ ImageView $imageView$inlined;
                        final /* synthetic */ int $offsetFromCenterToBaseline$inlined;
                        {
                            this.$imageView$inlined = imageView;
                            this.$offsetFromCenterToBaseline$inlined = n;
                        }

                        public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                            view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                            View it = view;
                            boolean bl = false;
                            View it2 = it;
                            boolean bl2 = false;
                            ImageView $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = this.$imageView$inlined;
                            boolean bl3 = false;
                            $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setBaseline($this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.getHeight() / 2 + this.$offsetFromCenterToBaseline$inlined);
                            $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.post(new /* invalid duplicate definition of identical inner class */);
                        }
                    });
                }
            }
        } else {
            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(textView, imageView){
                final /* synthetic */ TextView $textView$inlined;
                final /* synthetic */ ImageView $imageView$inlined;
                {
                    this.$textView$inlined = textView;
                    this.$imageView$inlined = imageView;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    TextView $this$requireAs$iv = this.$textView$inlined;
                    boolean $i$f$requireAs = false;
                    TextView textView = $this$requireAs$iv;
                    if (textView == null) {
                        throw new NullPointerException("null cannot be cast to non-null type android.widget.TextView");
                    }
                    Layout $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416 = textView.getLayout();
                    boolean bl3 = false;
                    if ($this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416 != null) {
                        int validationFirstLineTop = $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416.getLineTop(0);
                        int validationFirstLineBottom = $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416.getLineBottom(0);
                        int validationFirstLineBaseLine = $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416.getLineBaseline(0);
                        int offsetFromCenterToBaseline = validationFirstLineBaseLine - (validationFirstLineBottom - validationFirstLineTop) / 2;
                        View $this$doOnLayout$iv = (View)this.$imageView$inlined;
                        boolean $i$f$doOnLayout = false;
                        if ($this$doOnLayout$iv.isLaidOut() && !$this$doOnLayout$iv.isLayoutRequested()) {
                            View it3 = $this$doOnLayout$iv;
                            boolean bl4 = false;
                            ImageView $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414 = this.$imageView$inlined;
                            boolean bl5 = false;
                            $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.setBaseline($this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.getHeight() / 2 + offsetFromCenterToBaseline);
                            $this$updateValidationIconPosition_u24lambda_u2417_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.post(new /* invalid duplicate definition of identical inner class */);
                        } else {
                            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
                            boolean $i$f$doOnNextLayout = false;
                            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new /* invalid duplicate definition of identical inner class */);
                        }
                    }
                }
            });
        }
    }

    private final void updateAssistiveTextMoreDisplay() {
        Layout layout2 = this.textAssistance.getLayout();
        if (layout2 != null) {
            boolean isEllipsized;
            boolean bl = isEllipsized = 0 < layout2.getEllipsisCount(0);
            if (isEllipsized) {
                ViewExtKt.show((View)this.buttonMoreAssistance);
            }
        }
    }

    private final void resetAssistiveTextMoreDisplay() {
        ViewExtKt.collapse((View)this.buttonMoreAssistance);
    }

    private final void showAssistiveTextDialog() {
        block0: {
            CharSequence charSequence = this.getAssistiveText();
            if (charSequence == null) break block0;
            CharSequence toolTipText = charSequence;
            boolean bl = false;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            new ToolTipDialog(context, toolTipText).show();
        }
    }

    private final void registerPreDrawListener() {
        if (!this.isPreDrawListenerRegistered) {
            this.isPreDrawListenerRegistered = true;
            this.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
        }
    }

    private static final void _init_$lambda$2(InputField this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.showAssistiveTextDialog();
    }

    private static final void showLabel$lambda$9$lambda$8(InputTextView $this_with) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        ViewExtKt.show((View)$this_with);
    }

    private static final void hideLabel$lambda$11$lambda$10(InputTextView $this_with) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        ViewExtKt.hide((View)$this_with);
    }

    public static final /* synthetic */ void access$setPreDrawListenerRegistered$p(InputField $this, boolean bl) {
        $this.isPreDrawListenerRegistered = bl;
    }

    public static final /* synthetic */ boolean access$getRequiresAssistiveTextMoreDisplayUpdate$p(InputField $this) {
        return $this.requiresAssistiveTextMoreDisplayUpdate;
    }

    public static final /* synthetic */ void access$setRequiresAssistiveTextMoreDisplayUpdate$p(InputField $this, boolean bl) {
        $this.requiresAssistiveTextMoreDisplayUpdate = bl;
    }

    public static final /* synthetic */ void access$updateAssistiveTextMoreDisplay(InputField $this) {
        $this.updateAssistiveTextMoreDisplay();
    }
}

