/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.new_arch.data.api;

import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.ReadyRemit;
import com.brightwell.readyremit.sdk.internal.api.ApiError;
import com.brightwell.readyremit.sdk.new_arch.data.api.APIResponse;
import com.brightwell.readyremit.sdk.new_arch.data.api.FailureAPI;
import com.brightwell.readyremit.sdk.new_arch.data.api.SuccessAPI;
import com.brightwell.readyremit.sdk.new_arch.data.api.UnexpectedException;
import com.brightwell.readyremit.sdk.new_arch.data.api.UnexpectedThrowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002BA\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0002H\u0016J\u001c\u0010\u000f\u001a\u00020\r2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0013H\u0016J$\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0001\u0010\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0017H\u0082\b\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/brightwell/readyremit/sdk/new_arch/data/api/APICallInterceptor;", "T", "Lretrofit2/Call;", "Lcom/brightwell/readyremit/sdk/new_arch/data/api/APIResponse;", "delegate", "errorListConverter", "Lretrofit2/Converter;", "Lokhttp3/ResponseBody;", "", "Lcom/brightwell/readyremit/sdk/internal/api/ApiError;", "errorSingleConverter", "(Lretrofit2/Call;Lretrofit2/Converter;Lretrofit2/Converter;)V", "cancel", "", "clone", "enqueue", "callback", "Lretrofit2/Callback;", "execute", "Lretrofit2/Response;", "expressionOrNull", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "handleResponse", "response", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "timeout", "Lokio/Timeout;", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nAPICallInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 APICallInterceptor.kt\ncom/brightwell/readyremit/sdk/new_arch/data/api/APICallInterceptor\n*L\n1#1,74:1\n66#1,4:75\n66#1,4:79\n*S KotlinDebug\n*F\n+ 1 APICallInterceptor.kt\ncom/brightwell/readyremit/sdk/new_arch/data/api/APICallInterceptor\n*L\n51#1:75,4\n53#1:79,4\n*E\n"})
public final class APICallInterceptor<T>
implements Call<APIResponse<T>> {
    @NotNull
    private final Call<T> delegate;
    @NotNull
    private final Converter<ResponseBody, List<ApiError>> errorListConverter;
    @NotNull
    private final Converter<ResponseBody, ApiError> errorSingleConverter;
    public static final int $stable = 8;

    public APICallInterceptor(@NotNull Call<T> delegate, @NotNull Converter<ResponseBody, List<ApiError>> errorListConverter, @NotNull Converter<ResponseBody, ApiError> errorSingleConverter) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter(errorListConverter, (String)"errorListConverter");
        Intrinsics.checkNotNullParameter(errorSingleConverter, (String)"errorSingleConverter");
        this.delegate = delegate;
        this.errorListConverter = errorListConverter;
        this.errorSingleConverter = errorSingleConverter;
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    @NotNull
    public Request request() {
        Request request = this.delegate.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request(...)");
        return request;
    }

    @NotNull
    public Timeout timeout() {
        Timeout timeout = this.delegate.timeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"timeout(...)");
        return timeout;
    }

    public void cancel() {
        this.delegate.cancel();
    }

    @NotNull
    public Call<APIResponse<T>> clone() {
        Call call = this.delegate.clone();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"clone(...)");
        return new APICallInterceptor<T>(call, this.errorListConverter, this.errorSingleConverter);
    }

    @NotNull
    public Response<APIResponse<T>> execute() {
        Response response;
        try {
            Response response2 = this.delegate.execute();
            Intrinsics.checkNotNullExpressionValue((Object)response2, (String)"execute(...)");
            response = Response.success(this.handleResponse(response2));
            Intrinsics.checkNotNull((Object)response);
        }
        catch (Exception ex) {
            Response response3 = Response.success(new UnexpectedException(ex));
            Intrinsics.checkNotNull((Object)response3);
            response = response3;
        }
        return response;
    }

    public void enqueue(@NotNull Callback<APIResponse<T>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.delegate.enqueue(new Callback<T>(callback, this){
            final /* synthetic */ Callback<APIResponse<T>> $callback;
            final /* synthetic */ APICallInterceptor<T> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                this.$callback.onResponse((Call)this.this$0, Response.success((Object)APICallInterceptor.access$handleResponse(this.this$0, response)));
            }

            public void onFailure(@NotNull Call<T> call, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                this.$callback.onResponse((Call)this.this$0, Response.success(new UnexpectedThrowable<T>(throwable)));
            }
        });
    }

    private final APIResponse<T> handleResponse(Response<T> response) {
        APIResponse aPIResponse;
        try {
            APIResponse aPIResponse2;
            ReadyRemit.INSTANCE.setRequestIdValue(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)response.headers().values("Request-Id").toString(), (CharSequence)"["), (CharSequence)"]"));
            ReadyRemit.INSTANCE.setResponseErrorCode(String.valueOf(response.code()));
            int n = response.code();
            boolean bl = 200 <= n ? n < 301 : false;
            if (bl) {
                Object object = response.body();
                if (object != null) {
                    Object it = object;
                    boolean bl2 = false;
                    aPIResponse2 = new SuccessAPI<Object>(it);
                } else {
                    aPIResponse2 = new UnexpectedException(null);
                }
            } else {
                ResponseBody responseBody = response.errorBody();
                if (responseBody != null) {
                    List list;
                    ResponseBody errorBody = responseBody;
                    boolean bl3 = false;
                    APICallInterceptor this_$iv = this;
                    boolean $i$f$expressionOrNull = false;
                    try {
                        boolean bl4 = false;
                        list = (List)this.errorListConverter.convert((Object)errorBody);
                    }
                    catch (Throwable e$iv) {
                        list = null;
                    }
                    List list2 = list;
                    if (list2 != null) {
                        List apiError = list2;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)apiError);
                        aPIResponse2 = new FailureAPI(((ApiError)CollectionsKt.first((List)apiError)).withErrorCode());
                    } else {
                        ApiError apiError;
                        APICallInterceptor this_$iv2 = this;
                        boolean $i$f$expressionOrNull2 = false;
                        try {
                            boolean bl6 = false;
                            apiError = (ApiError)this.errorSingleConverter.convert((Object)errorBody);
                        }
                        catch (Throwable e$iv) {
                            apiError = null;
                        }
                        ApiError apiError2 = apiError;
                        if (apiError2 != null) {
                            ApiError it = apiError2;
                            boolean bl7 = false;
                            aPIResponse2 = new FailureAPI(it.withErrorCode());
                        } else {
                            aPIResponse2 = new UnexpectedException(null);
                        }
                    }
                } else {
                    APICallInterceptor $this$handleResponse_u24lambda_u246 = this;
                    boolean bl8 = false;
                    aPIResponse2 = new UnexpectedException(null);
                }
            }
            aPIResponse = aPIResponse2;
        }
        catch (Exception exception) {
            aPIResponse = new UnexpectedException(exception);
        }
        return aPIResponse;
    }

    private final <R> R expressionOrNull(Function0<? extends R> block) {
        Object object;
        boolean $i$f$expressionOrNull = false;
        try {
            object = block.invoke();
        }
        catch (Throwable e) {
            object = null;
        }
        return (R)object;
    }

    public static final /* synthetic */ APIResponse access$handleResponse(APICallInterceptor $this, Response response) {
        return $this.handleResponse(response);
    }
}

