/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils;

import android.text.InputFilter;
import android.text.Spanned;
import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/brightwell/readyremit/sdk/utils/DecimalDigitsInputFilter;", "Landroid/text/InputFilter;", "decimalDigits", "", "(I)V", "filter", "", "source", "start", "end", "dest", "Landroid/text/Spanned;", "dstart", "dend", "sdk_internalRelease"})
@StabilityInferred(parameters=1)
public final class DecimalDigitsInputFilter
implements InputFilter {
    private final int decimalDigits;
    public static final int $stable;

    public DecimalDigitsInputFilter(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    @Nullable
    public CharSequence filter(@NotNull CharSequence source, int start, int end, @NotNull Spanned dest, int dstart, int dend) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int dotPos = -1;
        int len = dest.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = dest.charAt(i2);
            if (c != '.' && c != ',') continue;
            dotPos = i2;
            break;
        }
        if (dotPos >= 0) {
            if (Intrinsics.areEqual((Object)source, (Object)".") || Intrinsics.areEqual((Object)source, (Object)",")) {
                return "";
            }
            if (dend <= dotPos) {
                return null;
            }
            if (len - dotPos > this.decimalDigits) {
                return "";
            }
        }
        return null;
    }
}

