/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.utils;

import android.content.res.Resources;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.new_arch.features.home.Holiday;
import com.squareup.moshi.FromJson;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.ToJson;
import com.squareup.moshi.Types;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/brightwell/readyremit/sdk/utils/JSONUtils;", "", "()V", "Companion", "LocalDateJsonAdapter", "sdk_internalRelease"})
@StabilityInferred(parameters=1)
public final class JSONUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ5\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/brightwell/readyremit/sdk/utils/JSONUtils$Companion;", "", "()V", "getJsonFileAsHolidays", "", "Lcom/brightwell/readyremit/sdk/new_arch/features/home/Holiday;", "resources", "Landroid/content/res/Resources;", "resId", "", "getJsonFileFromAdapter", "T", "adapter", "Lcom/squareup/moshi/JsonAdapter;", "(Landroid/content/res/Resources;ILcom/squareup/moshi/JsonAdapter;)Ljava/lang/Object;", "sdk_internalRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final List<Holiday> getJsonFileAsHolidays(@NotNull Resources resources, int resId) {
            Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
            Type[] typeArray = new Type[]{Holiday.class};
            ParameterizedType listType = Types.newParameterizedType((Type)((Type)((Object)List.class)), (Type[])typeArray);
            Moshi moshi = new Moshi.Builder().add((Object)new LocalDateJsonAdapter()).build();
            Intrinsics.checkNotNullExpressionValue((Object)moshi, (String)"build(...)");
            Moshi moshi2 = moshi;
            JsonAdapter jsonAdapter = moshi2.adapter((Type)listType);
            Intrinsics.checkNotNullExpressionValue((Object)jsonAdapter, (String)"adapter(...)");
            JsonAdapter adapter = jsonAdapter;
            return (List)this.getJsonFileFromAdapter(resources, resId, adapter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final <T> T getJsonFileFromAdapter(@NotNull Resources resources, int resId, @NotNull JsonAdapter<T> adapter) {
            Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
            Intrinsics.checkNotNullParameter(adapter, (String)"adapter");
            InputStream inputStream = resources.openRawResource(resId);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openRawResource(...)");
            InputStream resourceReader = inputStream;
            StringWriter writer = new StringWriter();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceReader, "UTF-8"));
                String line = reader.readLine();
                while (line != null) {
                    writer.write(line);
                    line = reader.readLine();
                }
                Object object = adapter.fromJson(writer.toString());
                return (T)object;
            }
            catch (Exception ex) {
                Log.e((String)"Error", (String)ex.toString());
            }
            finally {
                try {
                    resourceReader.close();
                }
                catch (Exception ex) {
                    Log.e((String)"Error", (String)ex.toString());
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0017\u00a8\u0006\r"}, d2={"Lcom/brightwell/readyremit/sdk/utils/JSONUtils$LocalDateJsonAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Ljava/time/LocalDate;", "()V", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "Companion", "sdk_internalRelease"})
    private static final class LocalDateJsonAdapter
    extends JsonAdapter<LocalDate> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("MM-dd-yyyy");

        @FromJson
        @Nullable
        public LocalDate fromJson(@NotNull JsonReader reader) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            LocalDate localDate = null;
            try {
                String dateAsString = reader.nextString();
                localDate = LocalDate.from(FORMATTER.parse(dateAsString));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return localDate;
        }

        @ToJson
        public void toJson(@NotNull JsonWriter writer, @Nullable LocalDate value) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            if (value != null) {
                writer.value(value.toString());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/brightwell/readyremit/sdk/utils/JSONUtils$LocalDateJsonAdapter$Companion;", "", "()V", "FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "sdk_internalRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

