/*
 * Decompiled with CFR 0.152.
 */
package com.brightwell.readyremit.sdk.internal.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.compose.runtime.internal.StabilityInferred;
import com.brightwell.readyremit.sdk.R;
import com.brightwell.readyremit.sdk.internal.api.data.ApiError;
import com.squareup.moshi.Moshi;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.HttpException;
import retrofit2.Response;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/brightwell/readyremit/sdk/internal/api/HttpErrorHandler;", "", "moshi", "Lcom/squareup/moshi/Moshi;", "(Lcom/squareup/moshi/Moshi;)V", "getAPIErrorMessage", "", "context", "Landroid/content/Context;", "responseBody", "Lokhttp3/ResponseBody;", "getErrorMessage", "ex", "Lretrofit2/HttpException;", "sdk_internalRelease"})
@StabilityInferred(parameters=0)
public final class HttpErrorHandler {
    @NotNull
    private final Moshi moshi;
    public static final int $stable = 8;

    @Inject
    public HttpErrorHandler(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        this.moshi = moshi;
    }

    @NotNull
    public final String getErrorMessage(@NotNull Context context, @NotNull HttpException ex) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (ex.code() == 401 || ex.code() == 422) {
            Response response = ex.response();
            string2 = this.getAPIErrorMessage(context, (ResponseBody)(response != null ? response.errorBody() : null));
        } else {
            String string3 = context.getString(R.string.error_server_error_message);
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        }
        return string2;
    }

    private final String getAPIErrorMessage(Context context, ResponseBody responseBody) {
        String string2 = context.getString(R.string.something_went_wrong);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        Object result = string2;
        try {
            String error;
            ResponseBody responseBody2 = responseBody;
            String string3 = error = responseBody2 != null ? responseBody2.string() : null;
            if (error != null && !TextUtils.isEmpty((CharSequence)error)) {
                ApiError apiError;
                ApiError apiError2 = apiError = (ApiError)this.moshi.adapter(ApiError.class).fromJson(error);
                if ((apiError2 != null ? apiError2.getMessage() : null) != null) {
                    result = apiError.getMessage();
                    if (apiError.getErrors() != null) {
                        result = apiError.getErrors();
                    }
                } else {
                    result = error;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

